/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.jboss.netty.handler.codec.string;

import java.nio.charset.Charset;
import oadd.org.jboss.netty.buffer.ChannelBuffers;
import oadd.org.jboss.netty.channel.Channel;
import oadd.org.jboss.netty.channel.ChannelHandler;
import oadd.org.jboss.netty.channel.ChannelHandlerContext;
import oadd.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class StringEncoder
extends OneToOneEncoder {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    @Deprecated
    public StringEncoder(String charsetName) {
        this(Charset.forName(charsetName));
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof String) {
            return ChannelBuffers.copiedBuffer(ctx.getChannel().getConfig().getBufferFactory().getDefaultOrder(), (CharSequence)((String)msg), this.charset);
        }
        return msg;
    }
}

