/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.jboss.netty.handler.codec.marshalling;

import oadd.org.jboss.marshalling.ByteOutput;
import oadd.org.jboss.marshalling.Marshaller;
import oadd.org.jboss.netty.channel.Channel;
import oadd.org.jboss.netty.channel.ChannelHandler;
import oadd.org.jboss.netty.channel.ChannelHandlerContext;
import oadd.org.jboss.netty.handler.codec.marshalling.ChannelBufferByteOutput;
import oadd.org.jboss.netty.handler.codec.marshalling.MarshallerProvider;
import oadd.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class CompatibleMarshallingEncoder
extends OneToOneEncoder {
    private final MarshallerProvider provider;

    public CompatibleMarshallingEncoder(MarshallerProvider provider) {
        this.provider = provider;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        Marshaller marshaller = this.provider.getMarshaller(ctx);
        ChannelBufferByteOutput output = new ChannelBufferByteOutput(ctx.getChannel().getConfig().getBufferFactory(), 256);
        marshaller.start((ByteOutput)output);
        marshaller.writeObject(msg);
        marshaller.finish();
        marshaller.close();
        return output.getBuffer();
    }
}

