/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.user;

import java.util.concurrent.ThreadLocalRandom;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.Acks;
import oadd.org.apache.drill.exec.rpc.ResponseSender;
import oadd.org.apache.drill.exec.rpc.user.UserServer;
import oadd.org.apache.drill.exec.rpc.user.UserSession;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.work.WorkManager;
import oadd.org.apache.drill.exec.work.foreman.Foreman;
import oadd.org.apache.drill.exec.work.metadata.MetadataProvider;
import oadd.org.apache.drill.exec.work.prepare.PreparedStatementProvider;
import oadd.org.apache.drill.exec.work.user.PlanSplitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserWorker {
    static final Logger logger = LoggerFactory.getLogger(UserWorker.class);
    private final WorkManager.WorkerBee bee;
    private final UserSession.QueryCountIncrementer incrementer = new UserSession.QueryCountIncrementer(){

        @Override
        public void increment(UserSession session) {
            session.incrementQueryCount(this);
        }
    };

    public UserWorker(WorkManager.WorkerBee bee) {
        this.bee = bee;
    }

    private static UserBitShared.QueryId queryIdGenerator() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        long time = (int)(System.currentTimeMillis() / 1000L);
        long p1 = (Integer.MAX_VALUE - time << 32) + (long)r.nextInt();
        long p2 = r.nextLong();
        UserBitShared.QueryId id = UserBitShared.QueryId.newBuilder().setPart1(p1).setPart2(p2).build();
        return id;
    }

    public UserBitShared.QueryId submitWork(UserServer.UserClientConnection connection, UserProtos.RunQuery query) {
        UserBitShared.QueryId id = UserWorker.queryIdGenerator();
        this.incrementer.increment(connection.getSession());
        Foreman foreman = new Foreman(this.bee, this.bee.getContext(), connection, id, query);
        this.bee.addNewForeman(foreman);
        return id;
    }

    public GeneralRPCProtos.Ack cancelQuery(UserBitShared.QueryId query) {
        Foreman foreman = this.bee.getForemanForQueryId(query);
        if (foreman != null) {
            foreman.cancel();
        }
        return Acks.OK;
    }

    public GeneralRPCProtos.Ack resumeQuery(UserBitShared.QueryId queryId) {
        Foreman foreman = this.bee.getForemanForQueryId(queryId);
        if (foreman != null) {
            foreman.resume();
        }
        return Acks.OK;
    }

    public OptionManager getSystemOptions() {
        return this.bee.getContext().getOptionManager();
    }

    public UserProtos.QueryPlanFragments getQueryPlan(UserServer.UserClientConnection connection, UserProtos.GetQueryPlanFragments req) {
        UserBitShared.QueryId queryId = UserWorker.queryIdGenerator();
        UserProtos.QueryPlanFragments qPlanFragments = new PlanSplitter().planFragments(this.bee.getContext(), queryId, req, connection);
        return qPlanFragments;
    }

    public void submitCatalogMetadataWork(UserSession session, UserProtos.GetCatalogsReq req, ResponseSender sender) {
        this.bee.addNewWork(MetadataProvider.catalogs(session, this.bee.getContext(), req, sender));
    }

    public void submitSchemasMetadataWork(UserSession session, UserProtos.GetSchemasReq req, ResponseSender sender) {
        this.bee.addNewWork(MetadataProvider.schemas(session, this.bee.getContext(), req, sender));
    }

    public void submitTablesMetadataWork(UserSession session, UserProtos.GetTablesReq req, ResponseSender sender) {
        this.bee.addNewWork(MetadataProvider.tables(session, this.bee.getContext(), req, sender));
    }

    public void submitColumnsMetadataWork(UserSession session, UserProtos.GetColumnsReq req, ResponseSender sender) {
        this.bee.addNewWork(MetadataProvider.columns(session, this.bee.getContext(), req, sender));
    }

    public void submitPreparedStatementWork(UserServer.UserClientConnection connection, UserProtos.CreatePreparedStatementReq req, ResponseSender sender) {
        this.bee.addNewWork(new PreparedStatementProvider.PreparedStatementWorker(connection, this, sender, req));
    }
}

