/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.user;

import java.util.ArrayList;
import java.util.List;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.physical.PhysicalPlan;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.physical.base.PhysicalVisitor;
import oadd.org.apache.drill.exec.planner.fragment.Fragment;
import oadd.org.apache.drill.exec.planner.fragment.MakeFragmentsVisitor;
import oadd.org.apache.drill.exec.planner.fragment.contrib.SplittingParallelizer;
import oadd.org.apache.drill.exec.planner.sql.DrillSqlWorker;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.user.UserServer;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.util.MemoryAllocationUtilities;
import oadd.org.apache.drill.exec.util.Pointer;
import oadd.org.apache.drill.exec.work.QueryWorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanSplitter {
    static final Logger logger = LoggerFactory.getLogger(PlanSplitter.class);

    public UserProtos.QueryPlanFragments planFragments(DrillbitContext dContext, UserBitShared.QueryId queryId, UserProtos.GetQueryPlanFragments req, UserServer.UserClientConnection connection) {
        UserProtos.QueryPlanFragments.Builder responseBuilder = UserProtos.QueryPlanFragments.newBuilder();
        QueryContext queryContext = new QueryContext(connection.getSession(), dContext, queryId);
        responseBuilder.setQueryId(queryId);
        try {
            responseBuilder.addAllFragments(this.getFragments(dContext, req, queryContext, queryId));
            responseBuilder.setStatus(UserBitShared.QueryResult.QueryState.COMPLETED);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to produce PlanFragments for query id \"%s\" with request to %s plan", queryId, req.getSplitPlan() ? "split" : "no split");
            UserBitShared.DrillPBError error = UserBitShared.DrillPBError.newBuilder().setMessage(errorMessage).setErrorType(UserBitShared.DrillPBError.ErrorType.PLAN).build();
            responseBuilder.setStatus(UserBitShared.QueryResult.QueryState.FAILED);
            responseBuilder.setError(error);
        }
        return responseBuilder.build();
    }

    private List<BitControl.PlanFragment> getFragments(DrillbitContext dContext, UserProtos.GetQueryPlanFragments req, QueryContext queryContext, UserBitShared.QueryId queryId) throws Exception {
        PhysicalPlan plan;
        String query = req.getQuery();
        switch (req.getType()) {
            case SQL: {
                Pointer textPlan = new Pointer();
                plan = DrillSqlWorker.getPlan((QueryContext)queryContext, (String)query, textPlan);
                break;
            }
            case PHYSICAL: {
                plan = dContext.getPlanReader().readPhysicalPlan(query);
                break;
            }
            default: {
                throw new IllegalStateException("Planning fragments supports only SQL or PHYSICAL QueryType");
            }
        }
        MemoryAllocationUtilities.setupSortMemoryAllocations(plan, queryContext);
        PhysicalOperator rootOperator = (PhysicalOperator)plan.getSortedOperators(false).iterator().next();
        Fragment rootFragment = (Fragment)rootOperator.accept((PhysicalVisitor)MakeFragmentsVisitor.INSTANCE, null);
        SplittingParallelizer parallelizer = new SplittingParallelizer(queryContext);
        ArrayList<BitControl.PlanFragment> fragments = Lists.newArrayList();
        if (req.getSplitPlan()) {
            List queryWorkUnits = parallelizer.getSplitFragments(queryContext.getOptions().getOptionList(), queryContext.getCurrentEndpoint(), queryId, queryContext.getActiveEndpoints(), dContext.getPlanReader(), rootFragment, queryContext.getSession(), queryContext.getQueryContextInfo());
            for (QueryWorkUnit queryWorkUnit : queryWorkUnits) {
                fragments.add(queryWorkUnit.getRootFragment());
                List<BitControl.PlanFragment> childFragments = queryWorkUnit.getFragments();
                if (childFragments.isEmpty()) continue;
                throw new IllegalStateException("Split plans can not have more then one fragment");
            }
        } else {
            QueryWorkUnit queryWorkUnit = parallelizer.getFragments(queryContext.getOptions().getOptionList(), queryContext.getCurrentEndpoint(), queryId, queryContext.getActiveEndpoints(), dContext.getPlanReader(), rootFragment, queryContext.getSession(), queryContext.getQueryContextInfo());
            fragments.add(queryWorkUnit.getRootFragment());
            fragments.addAll(queryWorkUnit.getFragments());
        }
        return fragments;
    }
}

