/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.metadata;

import java.util.UUID;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.ImmutableList;
import oadd.io.netty.buffer.ByteBuf;
import oadd.org.apache.calcite.schema.SchemaPlus;
import oadd.org.apache.drill.common.exceptions.ErrorHelper;
import oadd.org.apache.drill.exec.ops.ViewExpansionContext;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.Response;
import oadd.org.apache.drill.exec.rpc.ResponseSender;
import oadd.org.apache.drill.exec.rpc.user.UserSession;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.server.options.OptionValue;
import oadd.org.apache.drill.exec.store.SchemaConfig;
import oadd.org.apache.drill.exec.store.SchemaTreeProvider;
import oadd.org.apache.drill.exec.store.ischema.InfoSchemaFilter;
import oadd.org.apache.drill.exec.store.ischema.InfoSchemaTableType;
import oadd.org.apache.drill.exec.store.ischema.Records;
import oadd.org.apache.drill.exec.store.pojo.PojoRecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(MetadataProvider.class);
    private static final String LIKE_FUNCTION = "like";
    private static final String AND_FUNCTION = "booleanand";
    private static final String OR_FUNCTION = "booleanor";

    public static Runnable catalogs(UserSession session, DrillbitContext dContext, UserProtos.GetCatalogsReq req, ResponseSender responseSender) {
        return new CatalogsProvider(session, dContext, req, responseSender);
    }

    public static Runnable schemas(UserSession session, DrillbitContext dContext, UserProtos.GetSchemasReq req, ResponseSender responseSender) {
        return new SchemasProvider(session, dContext, req, responseSender);
    }

    public static Runnable tables(UserSession session, DrillbitContext dContext, UserProtos.GetTablesReq req, ResponseSender responseSender) {
        return new TablesProvider(session, dContext, req, responseSender);
    }

    public static Runnable columns(UserSession session, DrillbitContext dContext, UserProtos.GetColumnsReq req, ResponseSender responseSender) {
        return new ColumnsProvider(session, dContext, req, responseSender);
    }

    private static InfoSchemaFilter createInfoSchemaFilter(UserProtos.LikeFilter catalogNameFilter, UserProtos.LikeFilter schemaNameFilter, UserProtos.LikeFilter tableNameFilter, UserProtos.LikeFilter columnNameFilter) {
        InfoSchemaFilter.FunctionExprNode exprNode = MetadataProvider.createLikeFunctionExprNode("CATALOG_NAME", catalogNameFilter);
        exprNode = MetadataProvider.combineFunctions(AND_FUNCTION, exprNode, MetadataProvider.combineFunctions(OR_FUNCTION, MetadataProvider.createLikeFunctionExprNode("TABLE_SCHEMA", schemaNameFilter), MetadataProvider.createLikeFunctionExprNode("SCHEMA_NAME", schemaNameFilter)));
        exprNode = MetadataProvider.combineFunctions(AND_FUNCTION, exprNode, MetadataProvider.createLikeFunctionExprNode("TABLE_NAME", tableNameFilter));
        return (exprNode = MetadataProvider.combineFunctions(AND_FUNCTION, exprNode, MetadataProvider.createLikeFunctionExprNode("COLUMN_NAME", columnNameFilter))) != null ? new InfoSchemaFilter((InfoSchemaFilter.ExprNode)exprNode) : null;
    }

    private static InfoSchemaFilter.FunctionExprNode createLikeFunctionExprNode(String fieldName, UserProtos.LikeFilter likeFilter) {
        if (likeFilter == null) {
            return null;
        }
        return new InfoSchemaFilter.FunctionExprNode(LIKE_FUNCTION, likeFilter.hasEscape() ? ImmutableList.of(new InfoSchemaFilter.FieldExprNode(fieldName), new InfoSchemaFilter.ConstantExprNode(likeFilter.getRegex()), new InfoSchemaFilter.ConstantExprNode(likeFilter.getEscape())) : ImmutableList.of(new InfoSchemaFilter.FieldExprNode(fieldName), new InfoSchemaFilter.ConstantExprNode(likeFilter.getRegex())));
    }

    private static InfoSchemaFilter.FunctionExprNode combineFunctions(String functionName, InfoSchemaFilter.FunctionExprNode func1, InfoSchemaFilter.FunctionExprNode func2) {
        if (func1 == null) {
            return func2;
        }
        if (func2 == null) {
            return func1;
        }
        return new InfoSchemaFilter.FunctionExprNode(functionName, ImmutableList.of(func1, func2));
    }

    private static PojoRecordReader getPojoRecordReader(InfoSchemaTableType tableType, InfoSchemaFilter filter, SchemaTreeProvider provider, UserSession userSession) {
        SchemaPlus rootSchema = provider.createRootSchema(userSession.getCredentials().getUserName(), MetadataProvider.newSchemaConfigInfoProvider(userSession));
        return tableType.getRecordReader(rootSchema, filter, userSession.getOptions());
    }

    private static SchemaConfig.SchemaConfigInfoProvider newSchemaConfigInfoProvider(final UserSession session) {
        return new SchemaConfig.SchemaConfigInfoProvider(){

            public ViewExpansionContext getViewExpansionContext() {
                throw new UnsupportedOperationException("View expansion context is not supported");
            }

            public OptionValue getOption(String optionKey) {
                return session.getOptions().getOption(optionKey);
            }
        };
    }

    private static UserBitShared.DrillPBError createPBError(String failedFunction, Throwable ex) {
        String errorId = UUID.randomUUID().toString();
        logger.error("Failed to {}. ErrorId: {}", failedFunction, errorId, ex);
        UserBitShared.DrillPBError.Builder builder = UserBitShared.DrillPBError.newBuilder();
        builder.setErrorType(UserBitShared.DrillPBError.ErrorType.SYSTEM);
        builder.setErrorId(errorId);
        if (ex.getMessage() != null) {
            builder.setMessage(ex.getMessage());
        }
        builder.setException(ErrorHelper.getWrapper(ex));
        return builder.build();
    }

    private static class ColumnsProvider
    extends MetadataRunnable {
        private final UserProtos.GetColumnsReq req;

        private ColumnsProvider(UserSession session, DrillbitContext dContext, UserProtos.GetColumnsReq req, ResponseSender responseSender) {
            super(session, dContext, responseSender);
            this.req = Preconditions.checkNotNull(req);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Response runInternal(UserSession session, SchemaTreeProvider schemaProvider) {
            UserProtos.GetColumnsResp.Builder respBuilder = UserProtos.GetColumnsResp.newBuilder();
            InfoSchemaFilter filter = MetadataProvider.createInfoSchemaFilter(this.req.hasCatalogNameFilter() ? this.req.getCatalogNameFilter() : null, this.req.hasSchameNameFilter() ? this.req.getSchameNameFilter() : null, this.req.hasTableNameFilter() ? this.req.getTableNameFilter() : null, this.req.hasColumnNameFilter() ? this.req.getColumnNameFilter() : null);
            try {
                PojoRecordReader records = MetadataProvider.getPojoRecordReader(InfoSchemaTableType.COLUMNS, filter, schemaProvider, session);
                for (Records.Column c : records) {
                    UserProtos.ColumnMetadata.Builder columnBuilder = UserProtos.ColumnMetadata.newBuilder();
                    columnBuilder.setCatalogName(c.TABLE_CATALOG);
                    columnBuilder.setSchemaName(c.TABLE_SCHEMA);
                    columnBuilder.setTableName(c.TABLE_NAME);
                    columnBuilder.setColumnName(c.COLUMN_NAME);
                    columnBuilder.setOrdinalPosition(c.ORDINAL_POSITION);
                    if (c.COLUMN_DEFAULT != null) {
                        columnBuilder.setDefaultValue(c.COLUMN_DEFAULT);
                    }
                    if ("YES".equalsIgnoreCase(c.IS_NULLABLE)) {
                        columnBuilder.setIsNullable(true);
                    } else {
                        columnBuilder.setIsNullable(false);
                    }
                    columnBuilder.setDataType(c.DATA_TYPE);
                    if (c.CHARACTER_MAXIMUM_LENGTH != null) {
                        columnBuilder.setCharMaxLength(c.CHARACTER_MAXIMUM_LENGTH);
                    }
                    if (c.CHARACTER_OCTET_LENGTH != null) {
                        columnBuilder.setCharOctetLength(c.CHARACTER_OCTET_LENGTH);
                    }
                    if (c.NUMERIC_PRECISION != null) {
                        columnBuilder.setNumericPrecision(c.NUMERIC_PRECISION);
                    }
                    if (c.NUMERIC_PRECISION_RADIX != null) {
                        columnBuilder.setNumericPrecisionRadix(c.NUMERIC_PRECISION_RADIX);
                    }
                    if (c.DATETIME_PRECISION != null) {
                        columnBuilder.setDateTimePrecision(c.DATETIME_PRECISION);
                    }
                    if (c.INTERVAL_TYPE != null) {
                        columnBuilder.setIntervalType(c.INTERVAL_TYPE);
                    }
                    if (c.INTERVAL_PRECISION != null) {
                        columnBuilder.setIntervalPrecision(c.INTERVAL_PRECISION);
                    }
                    respBuilder.addColumns(columnBuilder.build());
                }
                respBuilder.setStatus(UserProtos.RequestStatus.OK);
            }
            catch (Exception e) {
                respBuilder.setStatus(UserProtos.RequestStatus.FAILED);
                respBuilder.setError(MetadataProvider.createPBError("get columns", e));
            }
            finally {
                return new Response(UserProtos.RpcType.COLUMNS, respBuilder.build(), new ByteBuf[0]);
            }
        }
    }

    private static class TablesProvider
    extends MetadataRunnable {
        private final UserProtos.GetTablesReq req;

        private TablesProvider(UserSession session, DrillbitContext dContext, UserProtos.GetTablesReq req, ResponseSender responseSender) {
            super(session, dContext, responseSender);
            this.req = Preconditions.checkNotNull(req);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Response runInternal(UserSession session, SchemaTreeProvider schemaProvider) {
            UserProtos.GetTablesResp.Builder respBuilder = UserProtos.GetTablesResp.newBuilder();
            InfoSchemaFilter filter = MetadataProvider.createInfoSchemaFilter(this.req.hasCatalogNameFilter() ? this.req.getCatalogNameFilter() : null, this.req.hasSchameNameFilter() ? this.req.getSchameNameFilter() : null, this.req.hasTableNameFilter() ? this.req.getTableNameFilter() : null, null);
            try {
                PojoRecordReader records = MetadataProvider.getPojoRecordReader(InfoSchemaTableType.TABLES, filter, schemaProvider, session);
                for (Records.Table t : records) {
                    UserProtos.TableMetadata.Builder tableBuilder = UserProtos.TableMetadata.newBuilder();
                    tableBuilder.setCatalogName(t.TABLE_CATALOG);
                    tableBuilder.setSchemaName(t.TABLE_SCHEMA);
                    tableBuilder.setTableName(t.TABLE_NAME);
                    tableBuilder.setType(t.TABLE_TYPE);
                    respBuilder.addTables(tableBuilder.build());
                }
                respBuilder.setStatus(UserProtos.RequestStatus.OK);
            }
            catch (Throwable e) {
                respBuilder.setStatus(UserProtos.RequestStatus.FAILED);
                respBuilder.setError(MetadataProvider.createPBError("get tables", e));
            }
            finally {
                return new Response(UserProtos.RpcType.TABLES, respBuilder.build(), new ByteBuf[0]);
            }
        }
    }

    private static class SchemasProvider
    extends MetadataRunnable {
        private final UserProtos.GetSchemasReq req;

        private SchemasProvider(UserSession session, DrillbitContext dContext, UserProtos.GetSchemasReq req, ResponseSender responseSender) {
            super(session, dContext, responseSender);
            this.req = Preconditions.checkNotNull(req);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Response runInternal(UserSession session, SchemaTreeProvider schemaProvider) {
            UserProtos.GetSchemasResp.Builder respBuilder = UserProtos.GetSchemasResp.newBuilder();
            InfoSchemaFilter filter = MetadataProvider.createInfoSchemaFilter(this.req.hasCatalogNameFilter() ? this.req.getCatalogNameFilter() : null, this.req.hasSchameNameFilter() ? this.req.getSchameNameFilter() : null, null, null);
            try {
                PojoRecordReader records = MetadataProvider.getPojoRecordReader(InfoSchemaTableType.SCHEMATA, filter, schemaProvider, session);
                for (Records.Schema s : records) {
                    UserProtos.SchemaMetadata.Builder schemaBuilder = UserProtos.SchemaMetadata.newBuilder();
                    schemaBuilder.setCatalogName(s.CATALOG_NAME);
                    schemaBuilder.setSchemaName(s.SCHEMA_NAME);
                    schemaBuilder.setOwner(s.SCHEMA_OWNER);
                    schemaBuilder.setType(s.TYPE);
                    schemaBuilder.setMutable(s.IS_MUTABLE);
                    respBuilder.addSchemas(schemaBuilder.build());
                }
                respBuilder.setStatus(UserProtos.RequestStatus.OK);
            }
            catch (Throwable e) {
                respBuilder.setStatus(UserProtos.RequestStatus.FAILED);
                respBuilder.setError(MetadataProvider.createPBError("get schemas", e));
            }
            finally {
                return new Response(UserProtos.RpcType.SCHEMAS, respBuilder.build(), new ByteBuf[0]);
            }
        }
    }

    private static class CatalogsProvider
    extends MetadataRunnable {
        private final UserProtos.GetCatalogsReq req;

        public CatalogsProvider(UserSession session, DrillbitContext dContext, UserProtos.GetCatalogsReq req, ResponseSender responseSender) {
            super(session, dContext, responseSender);
            this.req = Preconditions.checkNotNull(req);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Response runInternal(UserSession session, SchemaTreeProvider schemaProvider) {
            UserProtos.GetCatalogsResp.Builder respBuilder = UserProtos.GetCatalogsResp.newBuilder();
            InfoSchemaFilter filter = MetadataProvider.createInfoSchemaFilter(this.req.hasCatalogNameFilter() ? this.req.getCatalogNameFilter() : null, null, null, null);
            try {
                PojoRecordReader records = MetadataProvider.getPojoRecordReader(InfoSchemaTableType.CATALOGS, filter, schemaProvider, session);
                for (Records.Catalog c : records) {
                    UserProtos.CatalogMetadata.Builder catBuilder = UserProtos.CatalogMetadata.newBuilder();
                    catBuilder.setCatalogName(c.CATALOG_NAME);
                    catBuilder.setDescription(c.CATALOG_DESCRIPTION);
                    catBuilder.setConnect(c.CATALOG_CONNECT);
                    respBuilder.addCatalogs(catBuilder.build());
                }
                respBuilder.setStatus(UserProtos.RequestStatus.OK);
            }
            catch (Throwable e) {
                respBuilder.setStatus(UserProtos.RequestStatus.FAILED);
                respBuilder.setError(MetadataProvider.createPBError("get catalogs", e));
            }
            finally {
                return new Response(UserProtos.RpcType.CATALOGS, respBuilder.build(), new ByteBuf[0]);
            }
        }
    }

    private static abstract class MetadataRunnable
    implements Runnable {
        protected final UserSession session;
        private final ResponseSender responseSender;
        private final DrillbitContext dContext;

        private MetadataRunnable(UserSession session, DrillbitContext dContext, ResponseSender responseSender) {
            this.session = Preconditions.checkNotNull(session);
            this.dContext = Preconditions.checkNotNull(dContext);
            this.responseSender = Preconditions.checkNotNull(responseSender);
        }

        @Override
        public void run() {
            try (SchemaTreeProvider schemaTreeProvider = new SchemaTreeProvider(this.dContext);){
                this.responseSender.send(this.runInternal(this.session, schemaTreeProvider));
            }
            catch (Throwable error) {
                logger.error("Unhandled metadata provider error", error);
            }
        }

        protected abstract Response runInternal(UserSession var1, SchemaTreeProvider var2);
    }
}

