/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.work.batch;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;
import oadd.com.google.common.collect.Queues;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.record.RawFragmentBatch;
import oadd.org.apache.drill.exec.work.batch.BaseRawBatchBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlimitedRawBatchBuffer
extends BaseRawBatchBuffer<RawFragmentBatch> {
    private static final Logger logger = LoggerFactory.getLogger(UnlimitedRawBatchBuffer.class);
    private final int softlimit;
    private final int startlimit;

    public UnlimitedRawBatchBuffer(FragmentContext context, int fragmentCount, int oppositeId) {
        super(context, fragmentCount);
        this.softlimit = this.bufferSizePerSocket * fragmentCount;
        this.startlimit = Math.max(this.softlimit / 2, 1);
        logger.trace("softLimit: {}, startLimit: {}", (Object)this.softlimit, (Object)this.startlimit);
        this.bufferQueue = new UnlimitedBufferQueue();
    }

    @Override
    protected void enqueueInner(RawFragmentBatch batch) throws IOException {
        if (this.bufferQueue.size() < this.softlimit) {
            batch.sendOk();
        }
        this.bufferQueue.add(batch);
    }

    @Override
    protected void upkeep(RawFragmentBatch batch) {
    }

    private class UnlimitedBufferQueue
    implements BaseRawBatchBuffer.BufferQueue<RawFragmentBatch> {
        private final LinkedBlockingDeque<RawFragmentBatch> buffer = Queues.newLinkedBlockingDeque();

        private UnlimitedBufferQueue() {
        }

        @Override
        public void addOomBatch(RawFragmentBatch batch) {
            this.buffer.addFirst(batch);
        }

        @Override
        public RawFragmentBatch poll() throws IOException {
            RawFragmentBatch batch = this.buffer.poll();
            if (batch != null) {
                batch.sendOk();
            }
            return batch;
        }

        @Override
        public RawFragmentBatch take() throws IOException, InterruptedException {
            RawFragmentBatch batch = this.buffer.take();
            batch.sendOk();
            return batch;
        }

        @Override
        public boolean checkForOutOfMemory() {
            return UnlimitedRawBatchBuffer.this.context.isOverMemoryLimit();
        }

        @Override
        public int size() {
            return this.buffer.size();
        }

        @Override
        public boolean isEmpty() {
            return this.buffer.size() == 0;
        }

        @Override
        public void add(RawFragmentBatch batch) {
            this.buffer.add(batch);
        }
    }
}

