/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.fn;

import java.io.IOException;
import java.io.OutputStream;
import oadd.com.fasterxml.jackson.core.JsonFactory;
import oadd.com.fasterxml.jackson.core.JsonGenerationException;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.vector.complex.fn.BasicJsonOutput;
import oadd.org.apache.drill.exec.vector.complex.fn.ExtendedJsonOutput;
import oadd.org.apache.drill.exec.vector.complex.fn.JsonOutput;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWriter {
    static final Logger logger = LoggerFactory.getLogger(JsonWriter.class);
    private final JsonFactory factory = new JsonFactory();
    private final JsonOutput gen;

    public JsonWriter(OutputStream out, boolean pretty, boolean useExtendedOutput) throws IOException {
        JsonGenerator writer = this.factory.createJsonGenerator(out);
        if (pretty) {
            writer = writer.useDefaultPrettyPrinter();
        }
        this.gen = useExtendedOutput ? new ExtendedJsonOutput(writer) : new BasicJsonOutput(writer);
    }

    public JsonWriter(JsonOutput gen) {
        this.gen = gen;
    }

    public void write(FieldReader reader) throws JsonGenerationException, IOException {
        this.writeValue(reader);
        this.gen.flush();
    }

    private void writeValue(FieldReader reader) throws JsonGenerationException, IOException {
        TypeProtos.DataMode m = reader.getType().getMode();
        TypeProtos.MinorType mt = reader.getType().getMinorType();
        switch (m) {
            case OPTIONAL: 
            case REQUIRED: {
                switch (mt) {
                    case FLOAT4: {
                        this.gen.writeFloat(reader);
                        break;
                    }
                    case FLOAT8: {
                        this.gen.writeDouble(reader);
                        break;
                    }
                    case INT: {
                        this.gen.writeInt(reader);
                        break;
                    }
                    case SMALLINT: {
                        this.gen.writeSmallInt(reader);
                        break;
                    }
                    case TINYINT: {
                        this.gen.writeTinyInt(reader);
                        break;
                    }
                    case BIGINT: {
                        this.gen.writeBigInt(reader);
                        break;
                    }
                    case BIT: {
                        this.gen.writeBoolean(reader);
                        break;
                    }
                    case DATE: {
                        this.gen.writeDate(reader);
                        break;
                    }
                    case TIME: {
                        this.gen.writeTime(reader);
                        break;
                    }
                    case TIMESTAMP: {
                        this.gen.writeTimestamp(reader);
                        break;
                    }
                    case INTERVALYEAR: 
                    case INTERVALDAY: 
                    case INTERVAL: {
                        this.gen.writeInterval(reader);
                        break;
                    }
                    case DECIMAL28DENSE: 
                    case DECIMAL28SPARSE: 
                    case DECIMAL38DENSE: 
                    case DECIMAL38SPARSE: 
                    case DECIMAL9: 
                    case DECIMAL18: {
                        this.gen.writeDecimal(reader);
                        break;
                    }
                    case LIST: {
                        this.gen.writeStartArray();
                        while (reader.next()) {
                            this.writeValue(reader.reader());
                        }
                        this.gen.writeEndArray();
                        break;
                    }
                    case MAP: {
                        this.gen.writeStartObject();
                        if (reader.isSet()) {
                            for (String name : reader) {
                                FieldReader childReader = reader.reader(name);
                                if (!childReader.isSet()) continue;
                                this.gen.writeFieldName(name);
                                this.writeValue(childReader);
                            }
                        }
                        this.gen.writeEndObject();
                        break;
                    }
                    case NULL: 
                    case LATE: {
                        this.gen.writeUntypedNull();
                        break;
                    }
                    case VAR16CHAR: {
                        this.gen.writeVar16Char(reader);
                        break;
                    }
                    case VARBINARY: {
                        this.gen.writeBinary(reader);
                        break;
                    }
                    case VARCHAR: {
                        this.gen.writeVarChar(reader);
                    }
                }
                break;
            }
            case REPEATED: {
                this.gen.writeStartArray();
                switch (mt) {
                    case FLOAT4: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeFloat(i, reader);
                        }
                        break;
                    }
                    case FLOAT8: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeDouble(i, reader);
                        }
                        break;
                    }
                    case INT: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeInt(i, reader);
                        }
                        break;
                    }
                    case SMALLINT: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeSmallInt(i, reader);
                        }
                        break;
                    }
                    case TINYINT: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeTinyInt(i, reader);
                        }
                        break;
                    }
                    case BIGINT: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeBigInt(i, reader);
                        }
                        break;
                    }
                    case BIT: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeBoolean(i, reader);
                        }
                        break;
                    }
                    case DATE: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeDate(i, reader);
                        }
                        break;
                    }
                    case TIME: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeTime(i, reader);
                        }
                        break;
                    }
                    case TIMESTAMP: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeTimestamp(i, reader);
                        }
                        break;
                    }
                    case INTERVALYEAR: 
                    case INTERVALDAY: 
                    case INTERVAL: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeInterval(i, reader);
                        }
                        break;
                    }
                    case DECIMAL28DENSE: 
                    case DECIMAL28SPARSE: 
                    case DECIMAL38DENSE: 
                    case DECIMAL38SPARSE: 
                    case DECIMAL9: 
                    case DECIMAL18: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeDecimal(i, reader);
                        }
                        break;
                    }
                    case LIST: {
                        for (int i = 0; i < reader.size(); ++i) {
                            while (reader.next()) {
                                this.writeValue(reader.reader());
                            }
                        }
                        break;
                    }
                    case MAP: {
                        while (reader.next()) {
                            this.gen.writeStartObject();
                            for (String name : reader) {
                                FieldReader mapField = reader.reader(name);
                                if (!mapField.isSet()) continue;
                                this.gen.writeFieldName(name);
                                this.writeValue(mapField);
                            }
                            this.gen.writeEndObject();
                        }
                        break;
                    }
                    case NULL: {
                        break;
                    }
                    case VAR16CHAR: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeVar16Char(i, reader);
                        }
                        break;
                    }
                    case VARBINARY: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeBinary(i, reader);
                        }
                        break;
                    }
                    case VARCHAR: {
                        for (int i = 0; i < reader.size(); ++i) {
                            this.gen.writeVarChar(i, reader);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unable to handle type %s.", mt));
                    }
                }
                this.gen.writeEndArray();
            }
        }
    }
}

