/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.List;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractContainerVector;
import oadd.org.apache.drill.exec.vector.complex.ListVector;
import oadd.org.apache.drill.exec.vector.complex.MapVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedMapVector;
import oadd.org.apache.drill.exec.vector.complex.UnionVector;
import oadd.org.apache.drill.exec.vector.complex.VectorWithOrdinal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldIdUtil {
    static final Logger logger = LoggerFactory.getLogger(FieldIdUtil.class);

    public static TypedFieldId getFieldIdIfMatchesUnion(UnionVector unionVector, TypedFieldId.Builder builder, boolean addToBreadCrumb, PathSegment seg) {
        if (seg.isNamed()) {
            MapVector v = unionVector.getMap();
            if (v != null) {
                return FieldIdUtil.getFieldIdIfMatches(v, builder, addToBreadCrumb, seg);
            }
            return null;
        }
        if (seg.isArray()) {
            ListVector v = unionVector.getList();
            if (v != null) {
                return FieldIdUtil.getFieldIdIfMatches(v, builder, addToBreadCrumb, seg);
            }
            return null;
        }
        return null;
    }

    public static TypedFieldId getFieldIdIfMatches(ValueVector vector, TypedFieldId.Builder builder, boolean addToBreadCrumb, PathSegment seg) {
        ValueVector v;
        if (vector instanceof RepeatedMapVector && seg != null && seg.isArray() && !seg.isLastPath()) {
            if (addToBreadCrumb) {
                addToBreadCrumb = false;
                builder.remainder(seg);
            }
            if ((seg = seg.getChild()).isArray()) {
                return null;
            }
        }
        if (seg == null) {
            if (addToBreadCrumb) {
                builder.intermediateType(vector.getField().getType());
            }
            return builder.finalType(vector.getField().getType()).build();
        }
        if (seg.isArray()) {
            if (seg.isLastPath()) {
                TypeProtos.MajorType type;
                if (vector instanceof AbstractContainerVector) {
                    type = ((AbstractContainerVector)vector).getLastPathType();
                } else if (vector instanceof ListVector) {
                    type = ((ListVector)vector).getDataVector().getField().getType();
                    builder.listVector();
                } else {
                    throw new UnsupportedOperationException("FieldIdUtil does not support vector of type " + vector.getField().getType());
                }
                builder.withIndex().finalType(type);
                if (addToBreadCrumb) {
                    addToBreadCrumb = false;
                    builder.remainder(seg);
                }
                return builder.build();
            }
            if (addToBreadCrumb) {
                addToBreadCrumb = false;
                builder.remainder(seg);
            }
        } else if (vector instanceof ListVector) {
            return null;
        }
        if (vector instanceof AbstractContainerVector) {
            VectorWithOrdinal vord = ((AbstractContainerVector)vector).getChildVectorWithOrdinal(seg.isArray() ? null : seg.getNameSegment().getPath());
            if (vord == null) {
                return null;
            }
            v = vord.vector;
            if (addToBreadCrumb) {
                builder.intermediateType(v.getField().getType());
                builder.addId(vord.ordinal);
            }
        } else if (vector instanceof ListVector) {
            v = ((ListVector)vector).getDataVector();
        } else {
            throw new UnsupportedOperationException("FieldIdUtil does not support vector of type " + vector.getField().getType());
        }
        if (v instanceof AbstractContainerVector) {
            AbstractContainerVector c = (AbstractContainerVector)v;
            return FieldIdUtil.getFieldIdIfMatches(c, builder, addToBreadCrumb, seg.getChild());
        }
        if (v instanceof ListVector) {
            ListVector list = (ListVector)v;
            return FieldIdUtil.getFieldIdIfMatches(list, builder, addToBreadCrumb, seg.getChild());
        }
        if (v instanceof UnionVector) {
            return FieldIdUtil.getFieldIdIfMatchesUnion((UnionVector)v, builder, addToBreadCrumb, seg.getChild());
        }
        if (seg.isNamed()) {
            if (addToBreadCrumb) {
                builder.intermediateType(v.getField().getType());
            }
            builder.finalType(v.getField().getType());
        } else {
            builder.finalType(v.getField().getType().toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build());
        }
        if (seg.isLastPath()) {
            return builder.build();
        }
        PathSegment child = seg.getChild();
        if (child.isLastPath() && child.isArray()) {
            if (addToBreadCrumb) {
                builder.remainder(child);
            }
            builder.withIndex();
            builder.finalType(v.getField().getType().toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build());
            return builder.build();
        }
        logger.warn("You tried to request a complex type inside a scalar object or path or type is wrong.");
        return null;
    }

    public static TypedFieldId getFieldId(ValueVector vector, int id, SchemaPath expectedPath, boolean hyper) {
        if (!expectedPath.getRootSegment().getNameSegment().getPath().equalsIgnoreCase(vector.getField().getPath())) {
            return null;
        }
        PathSegment.NameSegment seg = expectedPath.getRootSegment();
        TypedFieldId.Builder builder = TypedFieldId.newBuilder();
        if (hyper) {
            builder.hyper();
        }
        if (vector instanceof UnionVector) {
            builder.addId(id).remainder(expectedPath.getRootSegment().getChild());
            List<TypeProtos.MinorType> minorTypes = ((UnionVector)vector).getSubTypes();
            TypeProtos.MajorType.Builder majorTypeBuilder = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.UNION);
            for (TypeProtos.MinorType type : minorTypes) {
                majorTypeBuilder.addSubType(type);
            }
            TypeProtos.MajorType majorType = majorTypeBuilder.build();
            builder.intermediateType(majorType);
            if (seg.isLastPath()) {
                builder.finalType(majorType);
                return builder.build();
            }
            return FieldIdUtil.getFieldIdIfMatchesUnion((UnionVector)vector, builder, false, seg.getChild());
        }
        if (vector instanceof ListVector) {
            ListVector list = (ListVector)vector;
            builder.intermediateType(vector.getField().getType());
            builder.addId(id);
            return FieldIdUtil.getFieldIdIfMatches(list, builder, true, expectedPath.getRootSegment().getChild());
        }
        if (vector instanceof AbstractContainerVector) {
            AbstractContainerVector c = (AbstractContainerVector)vector;
            builder.intermediateType(vector.getField().getType());
            builder.addId(id);
            return FieldIdUtil.getFieldIdIfMatches(c, builder, true, expectedPath.getRootSegment().getChild());
        }
        builder.intermediateType(vector.getField().getType());
        builder.addId(id);
        builder.finalType(vector.getField().getType());
        if (seg.isLastPath()) {
            return builder.build();
        }
        PathSegment child = seg.getChild();
        if (child.isArray() && child.isLastPath()) {
            builder.remainder(child);
            builder.withIndex();
            builder.finalType(vector.getField().getType().toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build());
            return builder.build();
        }
        return null;
    }
}

