/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.exec.vector.UInt4Vector;

public class EmptyValuePopulator {
    private final UInt4Vector offsets;

    public EmptyValuePopulator(UInt4Vector offsets) {
        this.offsets = Preconditions.checkNotNull(offsets, "offsets cannot be null");
    }

    public void populate(int lastIndex) {
        if (lastIndex < 0) {
            throw new IndexOutOfBoundsException("index cannot be negative");
        }
        UInt4Vector.Accessor accessor = this.offsets.getAccessor();
        UInt4Vector.Mutator mutator = this.offsets.getMutator();
        int lastSet = Math.max(accessor.getValueCount() - 1, 0);
        int previousEnd = accessor.get(lastSet);
        for (int i = lastSet; i < lastIndex; ++i) {
            mutator.setSafe(i + 1, previousEnd);
        }
        mutator.setValueCount(lastIndex + 1);
    }
}

