/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.util.LinkedList;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.physical.PhysicalPlan;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.physical.config.ExternalSort;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryAllocationUtilities {
    private static final Logger logger = LoggerFactory.getLogger(MemoryAllocationUtilities.class);

    public static void setupSortMemoryAllocations(PhysicalPlan plan, QueryContext queryContext) {
        LinkedList<ExternalSort> sortList = new LinkedList<ExternalSort>();
        for (PhysicalOperator op : plan.getSortedOperators()) {
            if (!(op instanceof ExternalSort)) continue;
            sortList.add((ExternalSort)op);
        }
        if (sortList.size() > 0) {
            OptionManager optionManager = queryContext.getOptions();
            long maxWidthPerNode = optionManager.getOption((String)"planner.width.max_per_node").num_val;
            long maxAllocPerNode = Math.min(DrillConfig.getMaxDirectMemory(), queryContext.getConfig().getLong("drill.memory.top.max"));
            maxAllocPerNode = Math.min(maxAllocPerNode, optionManager.getOption((String)"planner.memory.max_query_memory_per_node").num_val);
            long maxSortAlloc = maxAllocPerNode / ((long)sortList.size() * maxWidthPerNode);
            logger.debug("Max sort alloc: {}", (Object)maxSortAlloc);
            for (ExternalSort externalSort : sortList) {
                externalSort.setMaxAllocation(maxSortAlloc);
            }
        }
    }
}

