/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.DrillBuf;
import oadd.io.netty.buffer.UnpooledByteBufAllocator;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.util.CoreDecimalUtility;
import oadd.org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import oadd.org.apache.drill.exec.expr.holders.Decimal38SparseHolder;

public class DecimalUtility
extends CoreDecimalUtility {
    public static final int MAX_DIGITS = 9;
    public static final int MAX_DIGITS_INT = 10;
    public static final int MAX_DIGITS_BIGINT = 19;
    public static final int DIGITS_BASE = 1000000000;
    public static final int DIGITS_MAX = 999999999;
    public static final int INTEGER_SIZE = 4;
    public static final String[] decimalToString = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000"};
    public static final long[] scale_long_constants = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public static long getPowerOfTen(int power) {
        assert (power >= 0 && power < scale_long_constants.length);
        return scale_long_constants[power];
    }

    public static long adjustScaleMultiply(long input, int factor) {
        int index = Math.abs(factor);
        assert (index >= 0 && index < scale_long_constants.length);
        if (factor >= 0) {
            return input * scale_long_constants[index];
        }
        return input / scale_long_constants[index];
    }

    public static long adjustScaleDivide(long input, int factor) {
        int index = Math.abs(factor);
        assert (index >= 0 && index < scale_long_constants.length);
        if (factor >= 0) {
            return input / scale_long_constants[index];
        }
        return input * scale_long_constants[index];
    }

    public static int roundUp(int ndigits) {
        return (ndigits + 9 - 1) / 9;
    }

    public static StringBuilder toStringWithZeroes(int number, int desiredLength) {
        String value = Integer.valueOf(number).toString();
        int length = value.length();
        StringBuilder str = new StringBuilder();
        str.append(decimalToString[desiredLength - length]);
        str.append(value);
        return str;
    }

    public static StringBuilder toStringWithZeroes(long number, int desiredLength) {
        int zeroesLength;
        String value = Long.valueOf(number).toString();
        int length = value.length();
        StringBuilder str = new StringBuilder();
        for (zeroesLength = desiredLength - length; zeroesLength > 9; zeroesLength -= 9) {
            str.append(decimalToString[9]);
        }
        str.append(decimalToString[zeroesLength]);
        str.append(value);
        return str;
    }

    public static BigDecimal getBigDecimalFromIntermediate(ByteBuf data, int startIndex, int nDecimalDigits, int scale) {
        return DecimalUtility.getBigDecimalFromDrillBuf(data, startIndex, nDecimalDigits, scale, false);
    }

    public static BigDecimal getBigDecimalFromSparse(DrillBuf data, int startIndex, int nDecimalDigits, int scale) {
        return DecimalUtility.getBigDecimalFromDrillBuf(data, startIndex, nDecimalDigits, scale, true);
    }

    public static BigDecimal getBigDecimalFromDrillBuf(DrillBuf bytebuf, int start, int length, int scale) {
        byte[] value = new byte[length];
        bytebuf.getBytes(start, value, 0, length);
        BigInteger unscaledValue = new BigInteger(value);
        return new BigDecimal(unscaledValue, scale);
    }

    public static BigDecimal getBigDecimalFromByteBuffer(ByteBuffer bytebuf, int start, int length, int scale) {
        byte[] value = new byte[length];
        bytebuf.get(value);
        BigInteger unscaledValue = new BigInteger(value);
        return new BigDecimal(unscaledValue, scale);
    }

    public static BigDecimal getBigDecimalFromDrillBuf(ByteBuf data, int startIndex, int nDecimalDigits, int scale, boolean truncateScale) {
        int actualDigits;
        BigInteger decimalDigits = BigInteger.valueOf(data.getInt(startIndex) & Integer.MAX_VALUE);
        BigInteger base = BigInteger.valueOf(1000000000L);
        for (int i = 1; i < nDecimalDigits; ++i) {
            BigInteger temp = BigInteger.valueOf(data.getInt(startIndex + i * 4));
            decimalDigits = decimalDigits.multiply(base);
            decimalDigits = decimalDigits.add(temp);
        }
        if (truncateScale && scale > 0 && (actualDigits = scale % 9) != 0) {
            BigInteger truncate = BigInteger.valueOf((int)Math.pow(10.0, 9 - actualDigits));
            decimalDigits = decimalDigits.divide(truncate);
        }
        if ((data.getInt(startIndex) & Integer.MIN_VALUE) != 0) {
            decimalDigits = decimalDigits.negate();
        }
        BigDecimal decimal = new BigDecimal(decimalDigits, scale);
        return decimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getBigDecimalFromDense(DrillBuf data, int startIndex, int nDecimalDigits, int scale, int maxPrecision, int width) {
        byte shiftBits;
        int shiftOrder;
        int maskIndex;
        byte[] intermediateBytes = new byte[(nDecimalDigits + 1) * 4];
        int intermediateIndex = 3;
        int[] mask = new int[]{3, 15, 63, 255};
        int[] reverseMask = new int[]{252, 240, 192, 0};
        if (maxPrecision == 38) {
            maskIndex = 0;
            shiftOrder = 6;
            shiftBits = 0;
            intermediateBytes[intermediateIndex++] = (byte)(data.getByte(startIndex) & 0x7F);
        } else if (maxPrecision == 28) {
            maskIndex = 1;
            shiftOrder = 4;
            shiftBits = (byte)((data.getByte(startIndex) & 3) << shiftOrder);
            intermediateBytes[intermediateIndex++] = (byte)((data.getByte(startIndex) & 0x3C & 0xFF) >>> 2);
        } else {
            throw new UnsupportedOperationException("Dense types with max precision 38 and 28 are only supported");
        }
        int inputIndex = 1;
        boolean sign = false;
        if ((data.getByte(startIndex) & 0x80) != 0) {
            sign = true;
        }
        while (inputIndex < width) {
            intermediateBytes[intermediateIndex] = (byte)(shiftBits | (data.getByte(startIndex + inputIndex) & reverseMask[maskIndex] & 0xFF) >>> 8 - shiftOrder);
            shiftBits = (byte)((data.getByte(startIndex + inputIndex) & mask[maskIndex]) << shiftOrder);
            ++intermediateIndex;
            if ((++inputIndex - 1) % 4 != 0) continue;
            shiftBits = (byte)((shiftBits & 0xFF) >>> 2);
            ++maskIndex;
            shiftOrder -= 2;
        }
        intermediateBytes[intermediateIndex] = shiftBits;
        if (sign) {
            intermediateBytes[0] = (byte)(intermediateBytes[0] | 0x80);
        }
        ByteBuf intermediate = UnpooledByteBufAllocator.DEFAULT.buffer(intermediateBytes.length);
        try {
            BigDecimal ret;
            intermediate.setBytes(0, intermediateBytes);
            BigDecimal bigDecimal = ret = DecimalUtility.getBigDecimalFromIntermediate(intermediate, 0, nDecimalDigits + 1, scale);
            return bigDecimal;
        }
        finally {
            intermediate.release();
        }
    }

    public static void getSparseFromBigDecimal(BigDecimal input, ByteBuf data, int startIndex, int scale, int precision, int nDecimalDigits) {
        for (int i = 0; i < nDecimalDigits; ++i) {
            data.setInt(startIndex + i * 4, 0);
        }
        boolean sign = false;
        if (input.signum() == -1) {
            sign = true;
            input = input.abs();
        }
        input = input.setScale(scale, 4);
        BigDecimal integerPart = input.setScale(0, 1);
        int destIndex = nDecimalDigits - DecimalUtility.roundUp(scale) - 1;
        BigDecimal base = new BigDecimal(1000000000);
        while (integerPart.compareTo(BigDecimal.ZERO) == 1) {
            data.setInt(startIndex + destIndex * 4, integerPart.remainder(base).intValue());
            --destIndex;
            integerPart = integerPart.divide(base).setScale(0, 1);
        }
        int actualDigits = scale % 9;
        if (actualDigits != 0) {
            input = input.setScale(scale += 9 - actualDigits, 1);
        }
        BigDecimal fractionalPart = input.remainder(BigDecimal.ONE).movePointRight(scale);
        destIndex = nDecimalDigits - 1;
        while (scale > 0) {
            fractionalPart = fractionalPart.movePointLeft(9);
            BigDecimal temp = fractionalPart.remainder(BigDecimal.ONE);
            data.setInt(startIndex + destIndex * 4, temp.unscaledValue().intValue());
            --destIndex;
            fractionalPart = fractionalPart.setScale(0, 1);
            scale -= 9;
        }
        if (sign) {
            data.setInt(startIndex, data.getInt(startIndex) | Integer.MIN_VALUE);
        }
    }

    public static long getDecimal18FromBigDecimal(BigDecimal input, int scale, int precision) {
        input = input.setScale(scale, 4);
        return input.unscaledValue().longValue();
    }

    public static BigDecimal getBigDecimalFromPrimitiveTypes(int input, int scale, int precision) {
        return BigDecimal.valueOf(input, scale);
    }

    public static BigDecimal getBigDecimalFromPrimitiveTypes(long input, int scale, int precision) {
        return BigDecimal.valueOf(input, scale);
    }

    public static int compareDenseBytes(DrillBuf left, int leftStart, boolean leftSign, DrillBuf right, int rightStart, boolean rightSign, int width) {
        int invert = 1;
        if (leftSign != rightSign) {
            return leftSign ? -1 : 1;
        }
        if (leftSign) {
            invert = -1;
        }
        int cmp = 0;
        for (int i = 0; i < width; ++i) {
            byte rightByte;
            byte leftByte = left.getByte(leftStart + i);
            if ((leftByte & 0xFF) > ((rightByte = right.getByte(rightStart + i)) & 0xFF)) {
                cmp = 1;
                break;
            }
            if ((leftByte & 0xFF) >= (rightByte & 0xFF)) continue;
            cmp = -1;
            break;
        }
        return cmp *= invert;
    }

    public static int getIntegerFromSparseBuffer(DrillBuf buffer, int start, int index) {
        int value = buffer.getInt(start + index * 4);
        if (index == 0) {
            value &= Integer.MAX_VALUE;
        }
        return value;
    }

    public static void setInteger(DrillBuf buffer, int start, int index, int value) {
        buffer.setInt(start + index * 4, value);
    }

    public static int compareSparseBytes(DrillBuf left, int leftStart, boolean leftSign, int leftScale, int leftPrecision, DrillBuf right, int rightStart, boolean rightSign, int rightPrecision, int rightScale, int width, int nDecimalDigits, boolean absCompare) {
        int invert = 1;
        if (!absCompare) {
            if (leftSign != rightSign) {
                return leftSign ? -1 : 1;
            }
            if (leftSign) {
                invert = -1;
            }
        }
        int cmp = DecimalUtility.compareSparseBytesInner(left, leftStart, leftSign, leftScale, leftPrecision, right, rightStart, rightSign, rightPrecision, rightScale, width, nDecimalDigits);
        return cmp * invert;
    }

    public static int compareSparseBytesInner(DrillBuf left, int leftStart, boolean leftSign, int leftScale, int leftPrecision, DrillBuf right, int rightStart, boolean rightSign, int rightPrecision, int rightScale, int width, int nDecimalDigits) {
        int leftIndex1;
        int leftInt = leftPrecision - leftScale;
        int rightInt = rightPrecision - rightScale;
        int leftIntRoundedUp = DecimalUtility.roundUp(leftInt);
        int rightIntRoundedUp = DecimalUtility.roundUp(rightInt);
        int leftScaleRoundedUp = DecimalUtility.roundUp(leftScale);
        int rightScaleRoundedUp = DecimalUtility.roundUp(rightScale);
        int rightIndex1 = nDecimalDigits - rightScaleRoundedUp - rightIntRoundedUp;
        int leftStopIndex = nDecimalDigits - leftScaleRoundedUp;
        int rightStopIndex = nDecimalDigits - rightScaleRoundedUp;
        for (leftIndex1 = nDecimalDigits - leftScaleRoundedUp - leftIntRoundedUp; leftIndex1 < leftStopIndex && DecimalUtility.getIntegerFromSparseBuffer(left, leftStart, leftIndex1) == 0; ++leftIndex1) {
            --leftIntRoundedUp;
        }
        if (leftIndex1 == leftStopIndex) {
            leftIntRoundedUp = 0;
        }
        while (rightIndex1 < rightStopIndex && DecimalUtility.getIntegerFromSparseBuffer(right, rightStart, rightIndex1) == 0) {
            --rightIntRoundedUp;
            ++rightIndex1;
        }
        if (rightIndex1 == rightStopIndex) {
            rightIntRoundedUp = 0;
        }
        if (leftIntRoundedUp > rightIntRoundedUp) {
            return 1;
        }
        if (rightIntRoundedUp > leftIntRoundedUp) {
            return -1;
        }
        leftIndex1 = nDecimalDigits - leftScaleRoundedUp - leftIntRoundedUp;
        for (rightIndex1 = nDecimalDigits - rightScaleRoundedUp - rightIntRoundedUp; leftIndex1 < leftStopIndex && rightIndex1 < rightStopIndex; ++leftIndex1, ++rightIndex1) {
            if (DecimalUtility.getIntegerFromSparseBuffer(left, leftStart, leftIndex1) > DecimalUtility.getIntegerFromSparseBuffer(right, rightStart, rightIndex1)) {
                return 1;
            }
            if (DecimalUtility.getIntegerFromSparseBuffer(right, rightStart, rightIndex1) <= DecimalUtility.getIntegerFromSparseBuffer(left, leftStart, leftIndex1)) continue;
            return -1;
        }
        leftIndex1 = leftStopIndex;
        rightIndex1 = rightStopIndex;
        leftStopIndex = nDecimalDigits;
        rightStopIndex = nDecimalDigits;
        while (leftIndex1 < leftStopIndex && rightIndex1 < rightStopIndex) {
            if (DecimalUtility.getIntegerFromSparseBuffer(left, leftStart, leftIndex1) > DecimalUtility.getIntegerFromSparseBuffer(right, rightStart, rightIndex1)) {
                return 1;
            }
            if (DecimalUtility.getIntegerFromSparseBuffer(right, rightStart, rightIndex1) > DecimalUtility.getIntegerFromSparseBuffer(left, leftStart, leftIndex1)) {
                return -1;
            }
            ++leftIndex1;
            ++rightIndex1;
        }
        while (leftIndex1 < leftStopIndex) {
            if (DecimalUtility.getIntegerFromSparseBuffer(left, leftStart, leftIndex1) != 0) {
                return 1;
            }
            ++leftIndex1;
        }
        while (rightIndex1 < rightStopIndex) {
            if (DecimalUtility.getIntegerFromSparseBuffer(right, rightStart, rightIndex1) != 0) {
                return -1;
            }
            ++rightIndex1;
        }
        return 0;
    }

    public static BigDecimal getBigDecimalFromByteArray(byte[] bytes, int start, int length, int scale) {
        byte[] value = Arrays.copyOfRange(bytes, start, start + length);
        BigInteger unscaledValue = new BigInteger(value);
        return new BigDecimal(unscaledValue, scale);
    }

    public static void roundDecimal(DrillBuf result, int start, int nDecimalDigits, int desiredScale, int currentScale) {
        block13: {
            int origScaleRoundedUp;
            int newScaleRoundedUp;
            block14: {
                int truncateFactor;
                int destIndex;
                int srcIntIndex;
                int srcIndex;
                newScaleRoundedUp = DecimalUtility.roundUp(desiredScale);
                origScaleRoundedUp = DecimalUtility.roundUp(currentScale);
                if (desiredScale >= currentScale) break block14;
                boolean roundUp = false;
                int truncatedScaleIndex = desiredScale + 1;
                if (truncatedScaleIndex <= currentScale) {
                    int extractDigitIndex = nDecimalDigits - origScaleRoundedUp - 1;
                    int extractDigit = DecimalUtility.getIntegerFromSparseBuffer(result, start, extractDigitIndex += DecimalUtility.roundUp(truncatedScaleIndex));
                    int temp = 9 - truncatedScaleIndex % 9;
                    if (temp != 0) {
                        extractDigit /= (int)Math.pow(10.0, temp);
                    }
                    if (extractDigit % 10 > 4) {
                        roundUp = true;
                    }
                }
                if ((srcIndex = (srcIntIndex = nDecimalDigits - origScaleRoundedUp - 1) + newScaleRoundedUp) != (destIndex = nDecimalDigits - 1)) {
                    while (srcIndex >= 0) {
                        DecimalUtility.setInteger(result, start, destIndex--, DecimalUtility.getIntegerFromSparseBuffer(result, start, srcIndex--));
                    }
                    while (destIndex >= 0) {
                        DecimalUtility.setInteger(result, start, destIndex--, 0);
                    }
                    srcIndex = nDecimalDigits - 1;
                }
                if ((truncateFactor = 9 - desiredScale % 9) != 9) {
                    truncateFactor = (int)Math.pow(10.0, truncateFactor);
                    int fractionalDigits = DecimalUtility.getIntegerFromSparseBuffer(result, start, nDecimalDigits - 1);
                    DecimalUtility.setInteger(result, start, nDecimalDigits - 1, (fractionalDigits /= truncateFactor) * truncateFactor);
                }
                if (!roundUp) break block13;
                srcIndex = nDecimalDigits - 1;
                int carry = truncateFactor != 9 ? truncateFactor : 1;
                while (srcIndex >= 0) {
                    int value = DecimalUtility.getIntegerFromSparseBuffer(result, start, srcIndex);
                    if ((value += carry) >= 1000000000) {
                        DecimalUtility.setInteger(result, start, srcIndex--, value % 1000000000);
                        carry = value / 1000000000;
                        continue;
                    }
                    DecimalUtility.setInteger(result, start, srcIndex--, value);
                    carry = 0;
                    break block13;
                }
                break block13;
            }
            if (desiredScale > currentScale && newScaleRoundedUp > origScaleRoundedUp) {
                int srcIndex = 0;
                int destIndex = newScaleRoundedUp - origScaleRoundedUp;
                while (srcIndex < destIndex) {
                    if (DecimalUtility.getIntegerFromSparseBuffer(result, start, srcIndex++) == 0) continue;
                    throw new DrillRuntimeException("Truncate resulting in loss of integer part, reduce scale specified");
                }
                srcIndex = 0;
                while (destIndex < nDecimalDigits) {
                    DecimalUtility.setInteger(result, start, srcIndex++, DecimalUtility.getIntegerFromSparseBuffer(result, start, destIndex++));
                }
                while (srcIndex < nDecimalDigits) {
                    DecimalUtility.setInteger(result, start, srcIndex++, 0);
                }
            }
        }
    }

    public static int getFirstFractionalDigit(int decimal, int scale) {
        if (scale == 0) {
            return 0;
        }
        int temp = (int)DecimalUtility.adjustScaleDivide(decimal, scale - 1);
        return Math.abs(temp % 10);
    }

    public static int getFirstFractionalDigit(long decimal, int scale) {
        if (scale == 0) {
            return 0;
        }
        long temp = DecimalUtility.adjustScaleDivide(decimal, scale - 1);
        return (int)Math.abs(temp % 10L);
    }

    public static int getFirstFractionalDigit(DrillBuf data, int scale, int start, int nDecimalDigits) {
        if (scale == 0) {
            return 0;
        }
        int index = nDecimalDigits - DecimalUtility.roundUp(scale);
        return (int)DecimalUtility.adjustScaleDivide(data.getInt(start + index * 4), 8);
    }

    public static int compareSparseSamePrecScale(DrillBuf left, int lStart, byte[] right, int length) {
        boolean lSign = (left.getInt(lStart) & Integer.MIN_VALUE) != 0;
        boolean rSign = ByteFunctionHelpers.getSign((byte[])right);
        int cmp = 0;
        if (lSign != rSign) {
            return !lSign ? 1 : -1;
        }
        int invert = lSign ? -1 : 1;
        int lPos = lStart;
        boolean rPos = false;
        for (int n = 0; n < length / 4; ++n) {
            int rightInt;
            int leftInt = Decimal38SparseHolder.getInteger(n, lStart, left);
            if (leftInt == (rightInt = ByteFunctionHelpers.getInteger((byte[])right, (int)n))) continue;
            cmp = leftInt - rightInt > 0 ? 1 : -1;
            break;
        }
        return cmp * invert;
    }
}

