/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.Executor;
import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.InvalidProtocolBufferException;
import oadd.com.google.protobuf.MessageLite;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufInputStream;
import oadd.io.netty.channel.ChannelFuture;
import oadd.io.netty.channel.ChannelHandlerContext;
import oadd.io.netty.channel.EventLoopGroup;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.physical.impl.materialize.QueryWritableBatch;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.BasicServer;
import oadd.org.apache.drill.exec.rpc.OutOfMemoryHandler;
import oadd.org.apache.drill.exec.rpc.OutboundRpcMessage;
import oadd.org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.RemoteConnection;
import oadd.org.apache.drill.exec.rpc.Response;
import oadd.org.apache.drill.exec.rpc.ResponseSender;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.user.InboundImpersonationManager;
import oadd.org.apache.drill.exec.rpc.user.UserProtobufLengthDecoder;
import oadd.org.apache.drill.exec.rpc.user.UserRpcConfig;
import oadd.org.apache.drill.exec.rpc.user.UserSession;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticationException;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import oadd.org.apache.drill.exec.rpc.user.security.UserAuthenticatorFactory;
import oadd.org.apache.drill.exec.work.user.UserWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserServer
extends BasicServer<UserProtos.RpcType, UserClientConnectionImpl> {
    private static final Logger logger = LoggerFactory.getLogger(UserServer.class);
    final UserWorker worker;
    final BufferAllocator alloc;
    final UserAuthenticator authenticator;
    final InboundImpersonationManager impersonationManager;

    public UserServer(DrillConfig config, ScanResult classpathScan, BufferAllocator alloc, EventLoopGroup eventLoopGroup, UserWorker worker, Executor executor) throws DrillbitStartupException {
        super(UserRpcConfig.getMapping(config, executor), alloc.getAsByteBufAllocator(), eventLoopGroup);
        this.worker = worker;
        this.alloc = alloc;
        this.authenticator = config.getBoolean("drill.exec.security.user.auth.enabled") ? UserAuthenticatorFactory.createAuthenticator(config, classpathScan) : null;
        this.impersonationManager = config.getBoolean("drill.exec.impersonation.enabled") ? new InboundImpersonationManager() : null;
    }

    @Override
    protected MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        switch (rpcType) {
            case 1: {
                return GeneralRPCProtos.Ack.getDefaultInstance();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handle(UserClientConnectionImpl connection, int rpcType, ByteBuf pBody, ByteBuf dBody, ResponseSender responseSender) throws RpcException {
        switch (rpcType) {
            case 3: {
                logger.debug("Received query to run.  Returning query handle.");
                try {
                    UserProtos.RunQuery query = UserProtos.RunQuery.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    UserBitShared.QueryId queryId = this.worker.submitWork(connection, query);
                    responseSender.send(new Response(UserProtos.RpcType.QUERY_HANDLE, queryId, new ByteBuf[0]));
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding RunQuery body.", e);
                }
            }
            case 4: {
                try {
                    UserBitShared.QueryId queryId = UserBitShared.QueryId.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    GeneralRPCProtos.Ack ack = this.worker.cancelQuery(queryId);
                    responseSender.send(new Response(UserProtos.RpcType.ACK, ack, new ByteBuf[0]));
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding QueryId body.", e);
                }
            }
            case 11: {
                try {
                    UserBitShared.QueryId queryId = UserBitShared.QueryId.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    GeneralRPCProtos.Ack ack = this.worker.resumeQuery(queryId);
                    responseSender.send(new Response(UserProtos.RpcType.ACK, ack, new ByteBuf[0]));
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding QueryId body.", e);
                }
            }
            case 12: {
                try {
                    UserProtos.GetQueryPlanFragments req = UserProtos.GetQueryPlanFragments.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    responseSender.send(new Response(UserProtos.RpcType.QUERY_PLAN_FRAGMENTS, this.worker.getQueryPlan(connection, req), new ByteBuf[0]));
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding GetQueryPlanFragments body.", e);
                }
            }
            case 14: {
                try {
                    UserProtos.GetCatalogsReq req = UserProtos.GetCatalogsReq.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    this.worker.submitCatalogMetadataWork(connection.getSession(), req, responseSender);
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding GetCatalogsReq body.", e);
                }
            }
            case 15: {
                try {
                    UserProtos.GetSchemasReq req = UserProtos.GetSchemasReq.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    this.worker.submitSchemasMetadataWork(connection.getSession(), req, responseSender);
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding GetSchemasReq body.", e);
                }
            }
            case 16: {
                try {
                    UserProtos.GetTablesReq req = UserProtos.GetTablesReq.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    this.worker.submitTablesMetadataWork(connection.getSession(), req, responseSender);
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding GetTablesReq body.", e);
                }
            }
            case 17: {
                try {
                    UserProtos.GetColumnsReq req = UserProtos.GetColumnsReq.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    this.worker.submitColumnsMetadataWork(connection.getSession(), req, responseSender);
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding GetColumnsReq body.", e);
                }
            }
            case 22: {
                try {
                    UserProtos.CreatePreparedStatementReq req = UserProtos.CreatePreparedStatementReq.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    this.worker.submitPreparedStatementWork(connection, req, responseSender);
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding CreatePreparedStatementReq body.", e);
                }
            }
            default: {
                throw new UnsupportedOperationException(String.format("UserServer received rpc of unknown type.  Type was %d.", rpcType));
            }
        }
    }

    @Override
    public UserClientConnectionImpl initRemoteConnection(SocketChannel channel) {
        super.initRemoteConnection(channel);
        return new UserClientConnectionImpl(channel);
    }

    @Override
    protected BasicServer.ServerHandshakeHandler<UserProtos.UserToBitHandshake> getHandshakeHandler(final UserClientConnectionImpl connection) {
        return new BasicServer.ServerHandshakeHandler<UserProtos.UserToBitHandshake>((Internal.EnumLite)UserProtos.RpcType.HANDSHAKE, UserProtos.UserToBitHandshake.PARSER){

            @Override
            protected void consumeHandshake(ChannelHandlerContext ctx, UserProtos.UserToBitHandshake inbound) throws Exception {
                UserProtos.BitToUserHandshake handshakeResp = this.getHandshakeResponse(inbound);
                OutboundRpcMessage msg = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE, this.handshakeType, this.coordinationId, (MessageLite)handshakeResp, new ByteBuf[0]);
                ctx.writeAndFlush(msg);
                if (handshakeResp.getStatus() != UserProtos.HandshakeStatus.SUCCESS) {
                    throw new RpcException("Handshake request failed: " + handshakeResp.getErrorMessage());
                }
            }

            public UserProtos.BitToUserHandshake getHandshakeResponse(UserProtos.UserToBitHandshake inbound) throws Exception {
                logger.trace("Handling handshake from user to bit. {}", (Object)inbound);
                if (!inbound.hasSupportTimeout() || !inbound.getSupportTimeout()) {
                    connection.disableReadTimeout();
                    logger.warn("Timeout Disabled as client doesn't support it.", (Object)connection.getName());
                }
                UserProtos.BitToUserHandshake.Builder respBuilder = UserProtos.BitToUserHandshake.newBuilder().setRpcVersion(UserRpcConfig.RPC_VERSION);
                try {
                    if (inbound.getRpcVersion() != UserRpcConfig.RPC_VERSION) {
                        String errMsg = String.format("Invalid rpc version. Expected %d, actual %d.", UserRpcConfig.RPC_VERSION, inbound.getRpcVersion());
                        return UserServer.handleFailure(respBuilder, UserProtos.HandshakeStatus.RPC_VERSION_MISMATCH, errMsg, null);
                    }
                    if (UserServer.this.authenticator != null) {
                        try {
                            String password = "";
                            UserProtos.UserProperties props = inbound.getProperties();
                            for (int i = 0; i < props.getPropertiesCount(); ++i) {
                                UserProtos.Property prop = props.getProperties(i);
                                if (!"password".equalsIgnoreCase(prop.getKey())) continue;
                                password = prop.getValue();
                                break;
                            }
                            UserServer.this.authenticator.authenticate(inbound.getCredentials().getUserName(), password);
                        }
                        catch (UserAuthenticationException ex) {
                            return UserServer.handleFailure(respBuilder, UserProtos.HandshakeStatus.AUTH_FAILED, ex.getMessage(), ex);
                        }
                    }
                    connection.setUser(inbound);
                    return respBuilder.setStatus(UserProtos.HandshakeStatus.SUCCESS).build();
                }
                catch (Exception e) {
                    return UserServer.handleFailure(respBuilder, UserProtos.HandshakeStatus.UNKNOWN_FAILURE, e.getMessage(), e);
                }
            }
        };
    }

    private static UserProtos.BitToUserHandshake handleFailure(UserProtos.BitToUserHandshake.Builder respBuilder, UserProtos.HandshakeStatus status, String errMsg, Exception exception) {
        String errorId = UUID.randomUUID().toString();
        if (exception != null) {
            logger.error("Error {} in Handling handshake request: {}, {}", errorId, status, errMsg, exception);
        } else {
            logger.error("Error {} in Handling handshake request: {}, {}", errorId, status, errMsg);
        }
        return respBuilder.setStatus(status).setErrorId(errorId).setErrorMessage(errMsg).build();
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator, OutOfMemoryHandler outOfMemoryHandler) {
        return new UserProtobufLengthDecoder(allocator, outOfMemoryHandler);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.authenticator != null) {
                this.authenticator.close();
            }
        }
        catch (Exception e) {
            logger.warn("Failure closing authenticator.", e);
        }
        super.close();
    }

    public class UserClientConnectionImpl
    extends RemoteConnection
    implements UserClientConnection {
        private UserSession session;

        public UserClientConnectionImpl(SocketChannel channel) {
            super(channel, "user client");
        }

        void disableReadTimeout() {
            this.getChannel().pipeline().remove("timeout-handler");
        }

        void setUser(UserProtos.UserToBitHandshake inbound) throws IOException {
            this.session = UserSession.Builder.newBuilder().withCredentials(inbound.getCredentials()).withOptionManager(UserServer.this.worker.getSystemOptions()).withUserProperties(inbound.getProperties()).setSupportComplexTypes(inbound.getSupportComplexTypes()).build();
            String targetName = this.session.getTargetUserName();
            if (UserServer.this.impersonationManager != null && targetName != null) {
                UserServer.this.impersonationManager.replaceUserOnSession(targetName, this.session);
            }
        }

        @Override
        public UserSession getSession() {
            return this.session;
        }

        @Override
        public void sendResult(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, UserBitShared.QueryResult result) {
            logger.trace("Sending result to client with {}", (Object)result);
            UserServer.this.send(listener, this, UserProtos.RpcType.QUERY_RESULT, result, GeneralRPCProtos.Ack.class, true, new ByteBuf[0]);
        }

        @Override
        public void sendData(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, QueryWritableBatch result) {
            logger.trace("Sending data to client with {}", (Object)result);
            UserServer.this.send(listener, this, UserProtos.RpcType.QUERY_DATA, result.getHeader(), GeneralRPCProtos.Ack.class, false, result.getBuffers());
        }

        @Override
        public BufferAllocator getAllocator() {
            return UserServer.this.alloc;
        }

        @Override
        public ChannelFuture getChannelClosureFuture() {
            return this.getChannel().closeFuture();
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return this.getChannel().remoteAddress();
        }
    }

    public static interface UserClientConnection {
        public UserSession getSession();

        public void sendResult(RpcOutcomeListener<GeneralRPCProtos.Ack> var1, UserBitShared.QueryResult var2);

        public void sendData(RpcOutcomeListener<GeneralRPCProtos.Ack> var1, QueryWritableBatch var2);

        public ChannelFuture getChannelClosureFuture();

        public SocketAddress getRemoteAddress();
    }
}

