/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.selection;

import oadd.io.netty.buffer.ByteBuf;
import oadd.org.apache.drill.exec.exception.SchemaChangeException;
import oadd.org.apache.drill.exec.record.DeadBuf;

public class SelectionVector4
implements AutoCloseable {
    private ByteBuf data;
    private int recordCount;
    private int start;
    private int length;

    public SelectionVector4(ByteBuf vector, int recordCount, int batchRecordCount) throws SchemaChangeException {
        if (recordCount > 0x1FFFFFFF) {
            throw new SchemaChangeException(String.format("Currently, Drill can only support allocations up to 2gb in size.  You requested an allocation of %d bytes.", recordCount * 4));
        }
        this.recordCount = recordCount;
        this.start = 0;
        this.length = Math.min(batchRecordCount, recordCount);
        this.data = vector;
    }

    public int getTotalCount() {
        return this.recordCount;
    }

    public int getCount() {
        return this.length;
    }

    public void setCount(int length) {
        this.length = length;
        this.recordCount = length;
    }

    public void set(int index, int compound) {
        this.data.setInt(index * 4, compound);
    }

    public void set(int index, int recordBatch, int recordIndex) {
        this.data.setInt(index * 4, recordBatch << 16 | recordIndex & 0xFFFF);
    }

    public int get(int index) {
        return this.data.getInt((this.start + index) * 4);
    }

    public SelectionVector4 createNewWrapperCurrent(int batchRecordCount) {
        try {
            this.data.retain();
            SelectionVector4 sv4 = new SelectionVector4(this.data, this.recordCount, batchRecordCount);
            sv4.start = this.start;
            return sv4;
        }
        catch (SchemaChangeException e) {
            throw new IllegalStateException("This shouldn't happen.");
        }
    }

    public SelectionVector4 createNewWrapperCurrent() {
        return this.createNewWrapperCurrent(this.length);
    }

    public boolean next() {
        if (this.start + this.length >= this.recordCount) {
            this.start = this.recordCount;
            this.length = 0;
            return false;
        }
        this.start += this.length;
        int newEnd = Math.min(this.start + this.length, this.recordCount);
        this.length = newEnd - this.start;
        return true;
    }

    public void clear() {
        this.start = 0;
        this.length = 0;
        if (this.data != DeadBuf.DEAD_BUFFER) {
            this.data.release();
            this.data = DeadBuf.DEAD_BUFFER;
        }
    }

    @Override
    public void close() {
        this.clear();
    }
}

