/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Sets;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSchema
implements Iterable<MaterializedField> {
    static final Logger logger = LoggerFactory.getLogger(BatchSchema.class);
    final SelectionVectorMode selectionVectorMode;
    private final List<MaterializedField> fields;

    BatchSchema(SelectionVectorMode selectionVector, List<MaterializedField> fields) {
        this.fields = fields;
        this.selectionVectorMode = selectionVector;
    }

    public static SchemaBuilder newBuilder() {
        return new SchemaBuilder();
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public MaterializedField getColumn(int index) {
        if (index < 0 || index >= this.fields.size()) {
            return null;
        }
        return this.fields.get(index);
    }

    @Override
    public Iterator<MaterializedField> iterator() {
        return this.fields.iterator();
    }

    public SelectionVectorMode getSelectionVectorMode() {
        return this.selectionVectorMode;
    }

    public BatchSchema clone() {
        ArrayList<MaterializedField> newFields = Lists.newArrayList();
        newFields.addAll(this.fields);
        return new BatchSchema(this.selectionVectorMode, newFields);
    }

    public String toString() {
        return "BatchSchema [fields=" + this.fields + ", selectionVector=" + (Object)((Object)this.selectionVectorMode) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        result = 31 * result + (this.selectionVectorMode == null ? 0 : this.selectionVectorMode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BatchSchema other = (BatchSchema)obj;
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            TypeProtos.MajorType t1 = this.fields.get(i).getType();
            TypeProtos.MajorType t2 = other.fields.get(i).getType();
            if (!(t1 == null ? t2 != null : !this.majorTypeEqual(t1, t2))) continue;
            return false;
        }
        return this.selectionVectorMode == other.selectionVectorMode;
    }

    private boolean majorTypeEqual(TypeProtos.MajorType t1, TypeProtos.MajorType t2) {
        if (t1.equals(t2)) {
            return true;
        }
        if (!t1.getMinorType().equals(t2.getMinorType())) {
            return false;
        }
        if (!t1.getMode().equals(t2.getMode())) {
            return false;
        }
        return Sets.newHashSet(t1.getSubTypeList()).equals(Sets.newHashSet(t2.getSubTypeList()));
    }

    public static enum SelectionVectorMode {
        NONE(-1, false),
        TWO_BYTE(2, true),
        FOUR_BYTE(4, true);

        public boolean hasSelectionVector;
        public final int size;
        public static SelectionVectorMode[] DEFAULT;
        public static SelectionVectorMode[] NONE_AND_TWO;
        public static SelectionVectorMode[] NONE_AND_FOUR;
        public static SelectionVectorMode[] ALL;

        private SelectionVectorMode(int size, boolean hasSelectionVector) {
            this.size = size;
        }

        static {
            DEFAULT = new SelectionVectorMode[]{NONE};
            NONE_AND_TWO = new SelectionVectorMode[]{NONE, TWO_BYTE};
            NONE_AND_FOUR = new SelectionVectorMode[]{NONE, FOUR_BYTE};
            ALL = new SelectionVectorMode[]{NONE, TWO_BYTE, FOUR_BYTE};
        }
    }
}

