/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.util.concurrent.ListenableFuture;
import oadd.com.google.common.util.concurrent.ListeningExecutorService;
import oadd.com.google.common.util.concurrent.MoreExecutors;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.BufferManager;
import oadd.org.apache.drill.exec.ops.BufferManagerImpl;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.ops.OpProfileDef;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.ops.OperatorStats;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import oadd.org.apache.drill.exec.testing.ExecutionControls;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OperatorContextImpl
extends OperatorContext
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(OperatorContextImpl.class);
    private final BufferAllocator allocator;
    private final ExecutionControls executionControls;
    private boolean closed = false;
    private final PhysicalOperator popConfig;
    private final OperatorStats stats;
    private final BufferManager manager;
    private DrillFileSystem fs;
    private final ExecutorService executor;
    private ListeningExecutorService delegatePool;

    public OperatorContextImpl(PhysicalOperator popConfig, FragmentContext context) throws OutOfMemoryException {
        this.allocator = context.getNewChildAllocator(popConfig.getClass().getSimpleName(), popConfig.getOperatorId(), popConfig.getInitialAllocation(), popConfig.getMaxAllocation());
        this.popConfig = popConfig;
        this.manager = new BufferManagerImpl(this.allocator);
        OpProfileDef def = new OpProfileDef(popConfig.getOperatorId(), popConfig.getOperatorType(), OperatorContextImpl.getChildCount(popConfig));
        this.stats = context.getStats().newOperatorStats(def, this.allocator);
        this.executionControls = context.getExecutionControls();
        this.executor = context.getDrillbitContext().getExecutor();
    }

    public OperatorContextImpl(PhysicalOperator popConfig, FragmentContext context, OperatorStats stats) throws OutOfMemoryException {
        this.allocator = context.getNewChildAllocator(popConfig.getClass().getSimpleName(), popConfig.getOperatorId(), popConfig.getInitialAllocation(), popConfig.getMaxAllocation());
        this.popConfig = popConfig;
        this.manager = new BufferManagerImpl(this.allocator);
        this.stats = stats;
        this.executionControls = context.getExecutionControls();
        this.executor = context.getDrillbitContext().getExecutor();
    }

    @Override
    public DrillBuf replace(DrillBuf old, int newSize) {
        return this.manager.replace(old, newSize);
    }

    @Override
    public DrillBuf getManagedBuffer() {
        return this.manager.getManagedBuffer();
    }

    @Override
    public DrillBuf getManagedBuffer(int size) {
        return this.manager.getManagedBuffer(size);
    }

    @Override
    public ExecutionControls getExecutionControls() {
        return this.executionControls;
    }

    @Override
    public BufferAllocator getAllocator() {
        if (this.allocator == null) {
            throw new UnsupportedOperationException("Operator context does not have an allocator");
        }
        return this.allocator;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.closed) {
            logger.debug("Attempted to close Operator context for {}, but context is already closed", (Object)(this.popConfig != null ? this.popConfig.getClass().getName() : null));
            return;
        }
        logger.debug("Closing context for {}", (Object)(this.popConfig != null ? this.popConfig.getClass().getName() : null));
        this.manager.close();
        if (this.allocator != null) {
            this.allocator.close();
        }
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException e) {
                throw new DrillRuntimeException(e);
            }
        }
        this.closed = true;
    }

    @Override
    public OperatorStats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RESULT> ListenableFuture<RESULT> runCallableAs(final UserGroupInformation proxyUgi, final Callable<RESULT> callable) {
        OperatorContextImpl operatorContextImpl = this;
        synchronized (operatorContextImpl) {
            if (this.delegatePool == null) {
                this.delegatePool = MoreExecutors.listeningDecorator(this.executor);
            }
        }
        return this.delegatePool.submit(new Callable<RESULT>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RESULT call() throws Exception {
                Object result;
                Thread currentThread = Thread.currentThread();
                String originalThreadName = currentThread.getName();
                currentThread.setName(proxyUgi.getUserName() + ":task-delegate-thread");
                try {
                    result = proxyUgi.doAs(new PrivilegedExceptionAction<RESULT>(){

                        @Override
                        public RESULT run() throws Exception {
                            return callable.call();
                        }
                    });
                }
                finally {
                    currentThread.setName(originalThreadName);
                }
                return result;
            }
        });
    }

    @Override
    public DrillFileSystem newFileSystem(Configuration conf) throws IOException {
        Preconditions.checkState(this.fs == null, "Tried to create a second FileSystem. Can only be called once per OperatorContext");
        this.fs = new DrillFileSystem(conf, this.getStats());
        return this.fs;
    }
}

