/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.calcite.schema.SchemaPlus;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.ExecutionSetupException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.exception.ClassTransformationException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.ClassGenerator;
import oadd.org.apache.drill.exec.expr.CodeGenerator;
import oadd.org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.AccountingDataTunnel;
import oadd.org.apache.drill.exec.ops.AccountingUserConnection;
import oadd.org.apache.drill.exec.ops.BufferManager;
import oadd.org.apache.drill.exec.ops.BufferManagerImpl;
import oadd.org.apache.drill.exec.ops.Consumer;
import oadd.org.apache.drill.exec.ops.ContextInformation;
import oadd.org.apache.drill.exec.ops.FragmentStats;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.ops.OperatorContextImpl;
import oadd.org.apache.drill.exec.ops.OperatorStats;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.ops.SendingAccountor;
import oadd.org.apache.drill.exec.ops.StatusHandler;
import oadd.org.apache.drill.exec.ops.UdfUtilities;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.planner.physical.PlannerSettings;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.control.ControlTunnel;
import oadd.org.apache.drill.exec.rpc.user.UserServer;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.server.options.FragmentOptionManager;
import oadd.org.apache.drill.exec.server.options.OptionList;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.store.PartitionExplorer;
import oadd.org.apache.drill.exec.store.SchemaConfig;
import oadd.org.apache.drill.exec.testing.ExecutionControls;
import oadd.org.apache.drill.exec.util.ImpersonationUtil;
import oadd.org.apache.drill.exec.work.batch.IncomingBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentContext
implements AutoCloseable,
UdfUtilities {
    private static final Logger logger = LoggerFactory.getLogger(FragmentContext.class);
    private final Map<CoordinationProtos.DrillbitEndpoint, AccountingDataTunnel> tunnels = Maps.newHashMap();
    private final List<OperatorContextImpl> contexts = Lists.newLinkedList();
    private final DrillbitContext context;
    private final UserServer.UserClientConnection connection;
    private final QueryContext queryContext;
    private final FragmentStats stats;
    private final FunctionImplementationRegistry funcRegistry;
    private final BufferAllocator allocator;
    private final BitControl.PlanFragment fragment;
    private final ContextInformation contextInformation;
    private IncomingBuffers buffers;
    private final OptionManager fragmentOptions;
    private final BufferManager bufferManager;
    private ExecutorState executorState;
    private final ExecutionControls executionControls;
    private final SendingAccountor sendingAccountor = new SendingAccountor();
    private final Consumer<RpcException> exceptionConsumer = new Consumer<RpcException>(){

        @Override
        public void accept(RpcException e) {
            FragmentContext.this.fail(e);
        }

        @Override
        public void interrupt(InterruptedException e) {
            if (FragmentContext.this.shouldContinue()) {
                logger.error("Received an unexpected interrupt while waiting for the data send to complete.", e);
                FragmentContext.this.fail(e);
            }
        }
    };
    private final RpcOutcomeListener<GeneralRPCProtos.Ack> statusHandler = new StatusHandler(this.exceptionConsumer, this.sendingAccountor);
    private final AccountingUserConnection accountingUserConnection;

    public FragmentContext(DrillbitContext dbContext, BitControl.PlanFragment fragment, FunctionImplementationRegistry funcRegistry) throws ExecutionSetupException {
        this(dbContext, fragment, null, null, funcRegistry);
    }

    public FragmentContext(DrillbitContext dbContext, BitControl.PlanFragment fragment, QueryContext queryContext, UserServer.UserClientConnection connection, FunctionImplementationRegistry funcRegistry) throws ExecutionSetupException {
        OptionList list;
        this.context = dbContext;
        this.queryContext = queryContext;
        this.connection = connection;
        this.accountingUserConnection = new AccountingUserConnection(connection, this.sendingAccountor, this.statusHandler);
        this.fragment = fragment;
        this.funcRegistry = funcRegistry;
        this.contextInformation = new ContextInformation(fragment.getCredentials(), fragment.getContext());
        logger.debug("Getting initial memory allocation of {}", (Object)fragment.getMemInitial());
        logger.debug("Fragment max allocation: {}", (Object)fragment.getMemMax());
        if (!fragment.hasOptionsJson() || fragment.getOptionsJson().isEmpty()) {
            list = new OptionList();
        } else {
            try {
                list = dbContext.getLpPersistence().getMapper().readValue(fragment.getOptionsJson(), OptionList.class);
            }
            catch (Exception e) {
                throw new ExecutionSetupException("Failure while reading plan options.", e);
            }
        }
        this.fragmentOptions = new FragmentOptionManager((OptionManager)this.context.getOptionManager(), list);
        this.executionControls = new ExecutionControls(this.fragmentOptions, dbContext.getEndpoint());
        try {
            this.allocator = this.context.getAllocator().newChildAllocator("frag:" + QueryIdHelper.getFragmentId(fragment.getHandle()), fragment.getMemInitial(), fragment.getMemMax());
            Preconditions.checkNotNull(this.allocator, "Unable to acuqire allocator");
        }
        catch (OutOfMemoryException e) {
            throw UserException.memoryError(e).addContext("Fragment", this.getHandle().getMajorFragmentId() + ":" + this.getHandle().getMinorFragmentId()).build(logger);
        }
        catch (Throwable e) {
            throw new ExecutionSetupException("Failure while getting memory allocator for fragment.", e);
        }
        this.stats = new FragmentStats(this.allocator, fragment.getAssignment());
        this.bufferManager = new BufferManagerImpl(this.allocator);
    }

    public FragmentContext(DrillbitContext dbContext, BitControl.PlanFragment fragment, UserServer.UserClientConnection connection, FunctionImplementationRegistry funcRegistry) throws ExecutionSetupException {
        this(dbContext, fragment, null, connection, funcRegistry);
    }

    public OptionManager getOptions() {
        return this.fragmentOptions;
    }

    public void setBuffers(IncomingBuffers buffers) {
        Preconditions.checkArgument(this.buffers == null, "Can only set buffers once.");
        this.buffers = buffers;
    }

    public void setExecutorState(ExecutorState executorState) {
        Preconditions.checkArgument(this.executorState == null, "ExecutorState can only be set once.");
        this.executorState = executorState;
    }

    public void fail(Throwable cause) {
        this.executorState.fail(cause);
    }

    public boolean shouldContinue() {
        return this.executorState.shouldContinue();
    }

    public DrillbitContext getDrillbitContext() {
        return this.context;
    }

    public SchemaPlus getRootSchema() {
        if (this.queryContext == null) {
            this.fail(new UnsupportedOperationException("Schema tree can only be created in root fragment. This is a non-root fragment."));
            return null;
        }
        boolean isImpersonationEnabled = this.isImpersonationEnabled();
        SchemaConfig schemaConfig = SchemaConfig.newBuilder((String)(isImpersonationEnabled ? this.queryContext.getQueryUserName() : ImpersonationUtil.getProcessUserName()), (SchemaConfig.SchemaConfigInfoProvider)this.queryContext).setIgnoreAuthErrors(isImpersonationEnabled).build();
        return this.queryContext.getRootSchema(schemaConfig);
    }

    public CoordinationProtos.DrillbitEndpoint getIdentity() {
        return this.context.getEndpoint();
    }

    public FragmentStats getStats() {
        return this.stats;
    }

    @Override
    public ContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public CoordinationProtos.DrillbitEndpoint getForemanEndpoint() {
        return this.fragment.getForeman();
    }

    public ExecProtos.FragmentHandle getHandle() {
        return this.fragment.getHandle();
    }

    private String getFragIdString() {
        ExecProtos.FragmentHandle handle = this.getHandle();
        String frag = handle != null ? handle.getMajorFragmentId() + ":" + handle.getMinorFragmentId() : "0:0";
        return frag;
    }

    @Deprecated
    public BufferAllocator getAllocator() {
        if (this.allocator == null) {
            logger.debug("Fragment: " + this.getFragIdString() + " Allocator is NULL");
        }
        return this.allocator;
    }

    public BufferAllocator getNewChildAllocator(String operatorName, int operatorId, long initialReservation, long maximumReservation) throws OutOfMemoryException {
        return this.allocator.newChildAllocator("op:" + QueryIdHelper.getFragmentId(this.fragment.getHandle()) + ":" + operatorId + ":" + operatorName, initialReservation, maximumReservation);
    }

    public boolean isOverMemoryLimit() {
        return this.allocator.isOverLimit();
    }

    public <T> T getImplementationClass(ClassGenerator<T> cg) throws ClassTransformationException, IOException {
        return this.getImplementationClass(cg.getCodeGenerator());
    }

    public <T> T getImplementationClass(CodeGenerator<T> cg) throws ClassTransformationException, IOException {
        return (T)this.context.getCompiler().getImplementationClass(cg);
    }

    public <T> List<T> getImplementationClass(ClassGenerator<T> cg, int instanceCount) throws ClassTransformationException, IOException {
        return this.getImplementationClass(cg.getCodeGenerator(), instanceCount);
    }

    public <T> List<T> getImplementationClass(CodeGenerator<T> cg, int instanceCount) throws ClassTransformationException, IOException {
        return this.context.getCompiler().getImplementationClass(cg, instanceCount);
    }

    public AccountingUserConnection getUserDataTunnel() {
        Preconditions.checkState(this.connection != null, "Only Root fragment can get UserDataTunnel");
        return this.accountingUserConnection;
    }

    public ControlTunnel getControlTunnel(CoordinationProtos.DrillbitEndpoint endpoint) {
        return this.context.getController().getTunnel(endpoint);
    }

    public AccountingDataTunnel getDataTunnel(CoordinationProtos.DrillbitEndpoint endpoint) {
        AccountingDataTunnel tunnel = this.tunnels.get(endpoint);
        if (tunnel == null) {
            tunnel = new AccountingDataTunnel(this.context.getDataConnectionsPool().getTunnel(endpoint), this.sendingAccountor, this.statusHandler);
            this.tunnels.put(endpoint, tunnel);
        }
        return tunnel;
    }

    public IncomingBuffers getBuffers() {
        return this.buffers;
    }

    public OperatorContext newOperatorContext(PhysicalOperator popConfig, OperatorStats stats) throws OutOfMemoryException {
        OperatorContextImpl context = new OperatorContextImpl(popConfig, this, stats);
        this.contexts.add(context);
        return context;
    }

    public OperatorContext newOperatorContext(PhysicalOperator popConfig) throws OutOfMemoryException {
        OperatorContextImpl context = new OperatorContextImpl(popConfig, this);
        this.contexts.add(context);
        return context;
    }

    @Deprecated
    @VisibleForTesting
    public Throwable getFailureCause() {
        return this.executorState.getFailureCause();
    }

    @Deprecated
    @VisibleForTesting
    public boolean isFailed() {
        return this.executorState.isFailed();
    }

    public FunctionImplementationRegistry getFunctionRegistry() {
        return this.funcRegistry;
    }

    public DrillConfig getConfig() {
        return this.context.getConfig();
    }

    public void setFragmentLimit(long limit) {
        this.allocator.setLimit(limit);
    }

    public ExecutionControls getExecutionControls() {
        return this.executionControls;
    }

    public String getQueryUserName() {
        return this.fragment.getCredentials().getUserName();
    }

    public boolean isImpersonationEnabled() {
        if (this.getConfig() == null) {
            return false;
        }
        return this.getConfig().getBoolean("drill.exec.impersonation.enabled");
    }

    @Override
    public void close() {
        this.waitForSendComplete();
        for (OperatorContextImpl opContext : this.contexts) {
            this.suppressingClose(opContext);
        }
        this.suppressingClose(this.bufferManager);
        this.suppressingClose(this.buffers);
        this.suppressingClose(this.allocator);
    }

    private void suppressingClose(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public DrillBuf replace(DrillBuf old, int newSize) {
        return this.bufferManager.replace(old, newSize);
    }

    @Override
    public DrillBuf getManagedBuffer() {
        return this.bufferManager.getManagedBuffer();
    }

    public DrillBuf getManagedBuffer(int size) {
        return this.bufferManager.getManagedBuffer(size);
    }

    @Override
    public PartitionExplorer getPartitionExplorer() {
        throw new UnsupportedOperationException(String.format("The partition explorer interface can only be used in functions that can be evaluated at planning time. Make sure that the %s configuration option is set to true.", PlannerSettings.CONSTANT_FOLDING.getOptionName()));
    }

    public Executor getExecutor() {
        return this.context.getExecutor();
    }

    public void waitForSendComplete() {
        this.sendingAccountor.waitForSendComplete();
    }

    public static interface ExecutorState {
        public boolean shouldContinue();

        public void fail(Throwable var1);

        @Deprecated
        @VisibleForTesting
        public boolean isFailed();

        @Deprecated
        @VisibleForTesting
        public Throwable getFailureCause();
    }
}

