/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr.holders;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;

public final class Decimal28SparseHolder
implements ValueHolder {
    public static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.DECIMAL28SPARSE);
    public static final int WIDTH = 20;
    public int start;
    public DrillBuf buffer;
    public int scale;
    public int precision;
    public static final int maxPrecision = 28;
    public static final int nDecimalDigits = 5;

    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    public static int getInteger(int index, int start, DrillBuf buffer) {
        int value = buffer.getInt(start + index * 4);
        if (index == 0) {
            value &= Integer.MAX_VALUE;
        }
        return value;
    }

    public static void setInteger(int index, int value, int start, DrillBuf buffer) {
        buffer.setInt(start + index * 4, value);
    }

    public static void setSign(boolean sign, int start, DrillBuf buffer) {
        if (sign) {
            int value = Decimal28SparseHolder.getInteger(0, start, buffer);
            Decimal28SparseHolder.setInteger(0, value | Integer.MIN_VALUE, start, buffer);
        }
    }

    public static boolean getSign(int start, DrillBuf buffer) {
        return (buffer.getInt(start) & Integer.MIN_VALUE) != 0;
    }

    @Deprecated
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String toString() {
        throw new UnsupportedOperationException();
    }
}

