/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.netty.channel.epoll;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import oadd.io.netty.channel.Channel;
import oadd.io.netty.channel.ChannelFuture;
import oadd.io.netty.channel.ChannelPromise;
import oadd.io.netty.channel.EventLoop;
import oadd.io.netty.channel.epoll.AbstractEpollChannel;
import oadd.io.netty.channel.epoll.AbstractEpollStreamChannel;
import oadd.io.netty.channel.epoll.EpollSocketChannelConfig;
import oadd.io.netty.channel.epoll.EpollTcpInfo;
import oadd.io.netty.channel.epoll.Native;
import oadd.io.netty.channel.socket.ServerSocketChannel;
import oadd.io.netty.channel.socket.SocketChannel;
import oadd.io.netty.channel.unix.FileDescriptor;
import oadd.io.netty.util.concurrent.GlobalEventExecutor;
import oadd.io.netty.util.internal.OneTimeTask;

public final class EpollSocketChannel
extends AbstractEpollStreamChannel
implements SocketChannel {
    private final EpollSocketChannelConfig config = new EpollSocketChannelConfig(this);
    private volatile InetSocketAddress local;
    private volatile InetSocketAddress remote;

    EpollSocketChannel(Channel parent, int fd, InetSocketAddress remote) {
        super(parent, fd);
        this.remote = remote;
        this.local = Native.localAddress(fd);
    }

    public EpollSocketChannel() {
        super(Native.socketStreamFd());
    }

    public EpollSocketChannel(FileDescriptor fd) {
        super(fd);
        this.remote = Native.remoteAddress(fd.intValue());
        this.local = Native.localAddress(fd.intValue());
    }

    public EpollTcpInfo tcpInfo() {
        return this.tcpInfo(new EpollTcpInfo());
    }

    public EpollTcpInfo tcpInfo(EpollTcpInfo info) {
        Native.tcpInfo(this.fd().intValue(), info);
        return info;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        if (this.remote == null) {
            InetSocketAddress address = Native.remoteAddress(this.fd().intValue());
            if (address != null) {
                this.remote = address;
            }
            return address;
        }
        return this.remote;
    }

    @Override
    protected void doBind(SocketAddress local) throws Exception {
        InetSocketAddress localAddress = (InetSocketAddress)local;
        int fd = this.fd().intValue();
        Native.bind(fd, localAddress);
        this.local = Native.localAddress(fd);
    }

    @Override
    public EpollSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isInputShutdown() {
        return this.isInputShutdown0();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.isOutputShutdown0();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(final ChannelPromise promise) {
        Executor closeExecutor = ((EpollSocketChannelUnsafe)this.unsafe()).closeExecutor();
        if (closeExecutor != null) {
            closeExecutor.execute(new OneTimeTask(){

                @Override
                public void run() {
                    EpollSocketChannel.this.shutdownOutput0(promise);
                }
            });
        } else {
            EventLoop loop = this.eventLoop();
            if (loop.inEventLoop()) {
                this.shutdownOutput0(promise);
            } else {
                loop.execute(new OneTimeTask(){

                    @Override
                    public void run() {
                        EpollSocketChannel.this.shutdownOutput0(promise);
                    }
                });
            }
        }
        return promise;
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollSocketChannelUnsafe();
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (localAddress != null) {
            EpollSocketChannel.checkResolvable((InetSocketAddress)localAddress);
        }
        EpollSocketChannel.checkResolvable((InetSocketAddress)remoteAddress);
        int fd = this.fd().intValue();
        boolean connected = super.doConnect(remoteAddress, localAddress);
        if (connected) {
            this.remote = (InetSocketAddress)remoteAddress;
            return true;
        }
        this.local = Native.localAddress(fd);
        return connected;
    }

    private final class EpollSocketChannelUnsafe
    extends AbstractEpollStreamChannel.EpollStreamUnsafe {
        private EpollSocketChannelUnsafe() {
        }

        @Override
        protected Executor closeExecutor() {
            if (EpollSocketChannel.this.config().getSoLinger() > 0) {
                return GlobalEventExecutor.INSTANCE;
            }
            return null;
        }
    }
}

