/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.version;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionGenerator {
    private final FileWriter writer;

    public static void main(String[] args) throws IOException {
        File srcFile = new File(args[0] + "/org/apache/parquet/Version.java");
        File parent = (srcFile = srcFile.getAbsoluteFile()).getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Couldn't mkdirs for " + parent);
        }
        new VersionGenerator(srcFile).run();
    }

    public VersionGenerator(File file) throws IOException {
        this.writer = new FileWriter(file);
    }

    public void run() throws IOException {
        InputStream in = VersionGenerator.class.getResourceAsStream("/parquet-version.properties");
        if (in == null) {
            throw new IOException("/parquet-version.properties not found");
        }
        Properties props = new Properties();
        props.load(in);
        this.add("package org.apache.parquet;\n\n/**\n * This class is auto-generated by {@link org.apache.parquet.version.VersionGenerator}\n * Do not manually edit!\n */\n");
        this.add("public class Version {\n");
        this.add("  public static final String VERSION_NUMBER = \"");
        this.add(props.getProperty("versionNumber"));
        this.add("\";\n");
        this.add("  public static final String FULL_VERSION = \"");
        this.add(props.getProperty("fullVersion"));
        this.add("\";\n\n");
        this.add("  public static void main(String[] args) {\n");
        this.add("    System.out.println(FULL_VERSION);\n");
        this.add("  }\n");
        this.add("}\n");
        this.writer.close();
    }

    private void add(String s) throws IOException {
        this.writer.write(s);
    }
}

