/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.Decimal9Holder;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.NullableDecimal18Vector;
import org.apache.drill.exec.vector.NullableDecimal28SparseVector;
import org.apache.drill.exec.vector.NullableDecimal38SparseVector;
import org.apache.drill.exec.vector.NullableDecimal9Vector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.work.ExecErrorConstants;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUtilities {
    static final Logger logger = LoggerFactory.getLogger(HiveUtilities.class);

    public static Object convertPartitionType(TypeInfo typeInfo, String value, String defaultPartitionValue) {
        if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new DrillRuntimeException("Non-Primitive types are not allowed as partition column type in Hive, but received one: " + typeInfo.getCategory());
        }
        if (defaultPartitionValue.equals(value)) {
            return null;
        }
        PrimitiveObjectInspector.PrimitiveCategory pCat = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        try {
            switch (pCat) {
                case BINARY: {
                    return value.getBytes();
                }
                case BOOLEAN: {
                    return Boolean.parseBoolean(value);
                }
                case DECIMAL: {
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                    return HiveDecimalUtils.enforcePrecisionScale((HiveDecimal)HiveDecimal.create((String)value), (int)decimalTypeInfo.precision(), (int)decimalTypeInfo.scale());
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case BYTE: 
                case SHORT: 
                case INT: {
                    return Integer.parseInt(value);
                }
                case LONG: {
                    return Long.parseLong(value);
                }
                case STRING: 
                case VARCHAR: {
                    return value.getBytes();
                }
                case CHAR: {
                    return value.trim().getBytes();
                }
                case TIMESTAMP: {
                    return Timestamp.valueOf(value);
                }
                case DATE: {
                    return Date.valueOf(value);
                }
            }
        }
        catch (Exception e) {
            logger.trace("Failed to interpret '{}' value from partition value string '{}'", (Object)pCat, (Object)value);
            return null;
        }
        HiveUtilities.throwUnsupportedHiveDataTypeError(pCat.toString());
        return null;
    }

    public static void populateVector(ValueVector vector, DrillBuf managedBuffer, Object val, int start, int end) {
        TypeProtos.MinorType type = vector.getField().getType().getMinorType();
        switch (type) {
            case VARBINARY: {
                NullableVarBinaryVector v = (NullableVarBinaryVector)vector;
                byte[] value = (byte[])val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value, 0, value.length);
                }
                break;
            }
            case BIT: {
                NullableBitVector v = (NullableBitVector)vector;
                Boolean value = (Boolean)val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().set(i, value != false ? 1 : 0);
                }
                break;
            }
            case FLOAT8: {
                NullableFloat8Vector v = (NullableFloat8Vector)vector;
                double value = (Double)val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case FLOAT4: {
                NullableFloat4Vector v = (NullableFloat4Vector)vector;
                float value = ((Float)val).floatValue();
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                NullableIntVector v = (NullableIntVector)vector;
                int value = (Integer)val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case BIGINT: {
                NullableBigIntVector v = (NullableBigIntVector)vector;
                long value = (Long)val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case VARCHAR: {
                NullableVarCharVector v = (NullableVarCharVector)vector;
                byte[] value = (byte[])val;
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value, 0, value.length);
                }
                break;
            }
            case TIMESTAMP: {
                NullableTimeStampVector v = (NullableTimeStampVector)vector;
                DateTime ts = new DateTime(((Timestamp)val).getTime()).withZoneRetainFields(DateTimeZone.UTC);
                long value = ts.getMillis();
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case DATE: {
                NullableDateVector v = (NullableDateVector)vector;
                DateTime date = new DateTime(((Date)val).getTime()).withZoneRetainFields(DateTimeZone.UTC);
                long value = date.getMillis();
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, value);
                }
                break;
            }
            case DECIMAL9: {
                BigDecimal value = ((HiveDecimal)val).bigDecimalValue();
                NullableDecimal9Vector v = (NullableDecimal9Vector)vector;
                Decimal9Holder holder = new Decimal9Holder();
                holder.scale = v.getField().getScale();
                holder.precision = v.getField().getPrecision();
                holder.value = DecimalUtility.getDecimal9FromBigDecimal((BigDecimal)value, (int)holder.scale, (int)holder.precision);
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, holder);
                }
                break;
            }
            case DECIMAL18: {
                BigDecimal value = ((HiveDecimal)val).bigDecimalValue();
                NullableDecimal18Vector v = (NullableDecimal18Vector)vector;
                Decimal18Holder holder = new Decimal18Holder();
                holder.scale = v.getField().getScale();
                holder.precision = v.getField().getPrecision();
                holder.value = DecimalUtility.getDecimal18FromBigDecimal((BigDecimal)value, (int)holder.scale, (int)holder.precision);
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, holder);
                }
                break;
            }
            case DECIMAL28SPARSE: {
                int needSpace = 20;
                Preconditions.checkArgument((managedBuffer.capacity() > 20 ? 1 : 0) != 0, (Object)String.format("Not sufficient space in given managed buffer. Need %d bytes, buffer has %d bytes", 20, managedBuffer.capacity()));
                BigDecimal value = ((HiveDecimal)val).bigDecimalValue();
                NullableDecimal28SparseVector v = (NullableDecimal28SparseVector)vector;
                Decimal28SparseHolder holder = new Decimal28SparseHolder();
                holder.scale = v.getField().getScale();
                holder.precision = v.getField().getPrecision();
                holder.buffer = managedBuffer;
                holder.start = 0;
                DecimalUtility.getSparseFromBigDecimal((BigDecimal)value, (ByteBuf)holder.buffer, (int)0, (int)holder.scale, (int)holder.precision, (int)5);
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, holder);
                }
                break;
            }
            case DECIMAL38SPARSE: {
                int needSpace = 24;
                Preconditions.checkArgument((managedBuffer.capacity() > 24 ? 1 : 0) != 0, (Object)String.format("Not sufficient space in given managed buffer. Need %d bytes, buffer has %d bytes", 24, managedBuffer.capacity()));
                BigDecimal value = ((HiveDecimal)val).bigDecimalValue();
                NullableDecimal38SparseVector v = (NullableDecimal38SparseVector)vector;
                Decimal38SparseHolder holder = new Decimal38SparseHolder();
                holder.scale = v.getField().getScale();
                holder.precision = v.getField().getPrecision();
                holder.buffer = managedBuffer;
                holder.start = 0;
                DecimalUtility.getSparseFromBigDecimal((BigDecimal)value, (ByteBuf)holder.buffer, (int)0, (int)holder.scale, (int)holder.precision, (int)6);
                for (int i = start; i < end; ++i) {
                    v.getMutator().setSafe(i, holder);
                }
                break;
            }
        }
    }

    public static TypeProtos.MajorType getMajorTypeFromHiveTypeInfo(TypeInfo typeInfo, OptionManager options) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                TypeProtos.MinorType minorType = HiveUtilities.getMinorTypeFromHivePrimitiveTypeInfo(primitiveTypeInfo, options);
                TypeProtos.MajorType.Builder typeBuilder = TypeProtos.MajorType.newBuilder().setMinorType(minorType).setMode(TypeProtos.DataMode.OPTIONAL);
                if (primitiveTypeInfo.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                    typeBuilder.setPrecision(decimalTypeInfo.precision()).setScale(decimalTypeInfo.scale()).build();
                }
                return typeBuilder.build();
            }
        }
        HiveUtilities.throwUnsupportedHiveDataTypeError(typeInfo.getCategory().toString());
        return null;
    }

    public static TypeProtos.MinorType getMinorTypeFromHivePrimitiveTypeInfo(PrimitiveTypeInfo primitiveTypeInfo, OptionManager options) {
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BINARY: {
                return TypeProtos.MinorType.VARBINARY;
            }
            case BOOLEAN: {
                return TypeProtos.MinorType.BIT;
            }
            case DECIMAL: {
                if (!options.getOption((String)"planner.enable_decimal_data_type").bool_val.booleanValue()) {
                    throw UserException.unsupportedError().message(ExecErrorConstants.DECIMAL_DISABLE_ERR_MSG, new Object[0]).build(logger);
                }
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                return DecimalUtility.getDecimalDataType((int)decimalTypeInfo.precision());
            }
            case DOUBLE: {
                return TypeProtos.MinorType.FLOAT8;
            }
            case FLOAT: {
                return TypeProtos.MinorType.FLOAT4;
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                return TypeProtos.MinorType.INT;
            }
            case LONG: {
                return TypeProtos.MinorType.BIGINT;
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return TypeProtos.MinorType.VARCHAR;
            }
            case TIMESTAMP: {
                return TypeProtos.MinorType.TIMESTAMP;
            }
            case DATE: {
                return TypeProtos.MinorType.DATE;
            }
        }
        HiveUtilities.throwUnsupportedHiveDataTypeError(primitiveTypeInfo.getPrimitiveCategory().toString());
        return null;
    }

    public static Class<? extends InputFormat<?, ?>> getInputFormatClass(JobConf job, StorageDescriptor sd, Table table) throws Exception {
        String inputFormatName = sd.getInputFormat();
        if (Strings.isNullOrEmpty((String)inputFormatName)) {
            String storageHandlerClass = (String)table.getParameters().get("storage_handler");
            if (Strings.isNullOrEmpty((String)storageHandlerClass)) {
                throw new ExecutionSetupException("Unable to get Hive table InputFormat class. There is neither InputFormat class explicitly specified nor StorageHandler class");
            }
            HiveStorageHandler storageHandler = HiveUtils.getStorageHandler((Configuration)job, (String)storageHandlerClass);
            return storageHandler.getInputFormatClass();
        }
        return Class.forName(inputFormatName);
    }

    public static void addConfToJob(JobConf job, Properties properties) {
        for (Object obj : properties.keySet()) {
            job.set((String)obj, (String)properties.get(obj));
        }
    }

    public static Properties getPartitionMetadata(Partition partition, Table table) {
        Properties properties = MetaStoreUtils.getPartitionMetadata((Partition)partition, (Table)table);
        for (Map.Entry entry : table.getParameters().entrySet()) {
            if (entry.getKey() == null || entry.getKey() == null) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public static void throwUnsupportedHiveDataTypeError(String unsupportedType) {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(String.format("Unsupported Hive data type %s. ", unsupportedType));
        errMsg.append(System.getProperty("line.separator"));
        errMsg.append("Following Hive data types are supported in Drill for querying: ");
        errMsg.append("BOOLEAN, TINYINT, SMALLINT, INT, BIGINT, FLOAT, DOUBLE, DATE, TIMESTAMP, BINARY, DECIMAL, STRING, VARCHAR and CHAR");
        throw UserException.unsupportedError().message(errMsg.toString(), new Object[0]).build(logger);
    }
}

