/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.hive.HiveRecordReader;
import org.apache.drill.exec.store.hive.HiveSubScan;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.security.UserGroupInformation;

public class HiveScanBatchCreator
implements BatchCreator<HiveSubScan> {
    public ScanBatch getBatch(FragmentContext context, HiveSubScan config, List<RecordBatch> children) throws ExecutionSetupException {
        ArrayList readers = Lists.newArrayList();
        Table table = config.getTable();
        List<InputSplit> splits = config.getInputSplits();
        List<Partition> partitions = config.getPartitions();
        boolean hasPartitions = partitions != null && partitions.size() > 0;
        int i = 0;
        UserGroupInformation proxyUgi = ImpersonationUtil.createProxyUgi((String)config.getUserName(), (String)context.getQueryUserName());
        HiveConf hiveConf = config.getHiveConf();
        for (InputSplit split : splits) {
            readers.add(new HiveRecordReader(table, hasPartitions ? partitions.get(i++) : null, split, config.getColumns(), context, hiveConf, proxyUgi));
        }
        if (readers.size() == 0) {
            readers.add(new HiveRecordReader(table, null, null, config.getColumns(), context, hiveConf, proxyUgi));
        }
        return new ScanBatch((PhysicalOperator)config, context, readers.iterator());
    }
}

