/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(HiveMetadataProvider.class);
    public static final int RECORD_SIZE = 1024;
    private final HiveReadEntry hiveReadEntry;
    private final UserGroupInformation ugi;
    private final boolean isPartitionedTable;
    private final Map<Partition, List<InputSplitWrapper>> partitionInputSplitMap;
    private final HiveConf hiveConf;
    private List<InputSplitWrapper> tableInputSplits;
    private final Stopwatch watch = Stopwatch.createUnstarted();

    public HiveMetadataProvider(String userName, HiveReadEntry hiveReadEntry, HiveConf hiveConf) {
        this.hiveReadEntry = hiveReadEntry;
        this.ugi = ImpersonationUtil.createProxyUgi((String)userName);
        this.isPartitionedTable = hiveReadEntry.getTable().getPartitionKeysSize() > 0;
        this.partitionInputSplitMap = Maps.newHashMap();
        this.hiveConf = hiveConf;
    }

    public HiveStats getStats(HiveReadEntry hiveReadEntry) throws IOException {
        HiveStats hiveStats;
        Table table;
        Stopwatch timeGetStats;
        block8: {
            block9: {
                timeGetStats = Stopwatch.createStarted();
                table = hiveReadEntry.getTable();
                if (this.isPartitionedTable) break block8;
                Properties properties = MetaStoreUtils.getTableMetadata((Table)table);
                HiveStats stats = this.getStatsFromProps(properties);
                if (!stats.valid()) break block9;
                HiveStats hiveStats2 = stats;
                logger.debug("Took {} \u00b5s to get stats from {}.{}", new Object[]{timeGetStats.elapsed(TimeUnit.NANOSECONDS) / 1000L, table.getDbName(), table.getTableName()});
                return hiveStats2;
            }
            HiveStats hiveStats3 = this.getStatsEstimateFromInputSplits(this.getTableInputSplits());
            logger.debug("Took {} \u00b5s to get stats from {}.{}", new Object[]{timeGetStats.elapsed(TimeUnit.NANOSECONDS) / 1000L, table.getDbName(), table.getTableName()});
            return hiveStats3;
        }
        try {
            HiveStats aggStats = new HiveStats(0L, 0L);
            for (Partition partition : hiveReadEntry.getPartitions()) {
                Properties properties = HiveUtilities.getPartitionMetadata(partition, table);
                HiveStats stats = this.getStatsFromProps(properties);
                if (!stats.valid()) {
                    stats = this.getStatsEstimateFromInputSplits(this.getPartitionInputSplits(partition));
                }
                aggStats.add(stats);
            }
            hiveStats = aggStats;
        }
        catch (Exception e) {
            try {
                throw new IOException("Failed to get numRows from HiveTable", e);
            }
            catch (Throwable throwable) {
                logger.debug("Took {} \u00b5s to get stats from {}.{}", new Object[]{timeGetStats.elapsed(TimeUnit.NANOSECONDS) / 1000L, table.getDbName(), table.getTableName()});
                throw throwable;
            }
        }
        logger.debug("Took {} \u00b5s to get stats from {}.{}", new Object[]{timeGetStats.elapsed(TimeUnit.NANOSECONDS) / 1000L, table.getDbName(), table.getTableName()});
        return hiveStats;
    }

    private List<InputSplitWrapper> getTableInputSplits() throws Exception {
        Preconditions.checkState((!this.isPartitionedTable ? 1 : 0) != 0, (Object)"Works only for non-partitioned tables");
        if (this.tableInputSplits != null) {
            return this.tableInputSplits;
        }
        Properties properties = MetaStoreUtils.getTableMetadata((Table)this.hiveReadEntry.getTable());
        this.tableInputSplits = this.splitInputWithUGI(properties, this.hiveReadEntry.getTable().getSd(), null);
        return this.tableInputSplits;
    }

    private List<InputSplitWrapper> getPartitionInputSplits(Partition partition) throws Exception {
        if (this.partitionInputSplitMap.containsKey(partition)) {
            return this.partitionInputSplitMap.get(partition);
        }
        Properties properties = HiveUtilities.getPartitionMetadata(partition, this.hiveReadEntry.getTable());
        List<InputSplitWrapper> splits = this.splitInputWithUGI(properties, partition.getSd(), partition);
        this.partitionInputSplitMap.put(partition, splits);
        return splits;
    }

    public List<InputSplitWrapper> getInputSplits(HiveReadEntry hiveReadEntry) {
        ArrayList arrayList;
        Stopwatch timeGetSplits;
        block6: {
            timeGetSplits = Stopwatch.createStarted();
            if (this.isPartitionedTable) break block6;
            List<InputSplitWrapper> list = this.getTableInputSplits();
            logger.debug("Took {} \u00b5s to get InputSplits from {}.{}", new Object[]{timeGetSplits.elapsed(TimeUnit.NANOSECONDS) / 1000L, hiveReadEntry.getTable().getDbName(), hiveReadEntry.getTable().getTableName()});
            return list;
        }
        try {
            ArrayList splits = Lists.newArrayList();
            for (Partition p : hiveReadEntry.getPartitions()) {
                splits.addAll(this.getPartitionInputSplits(p));
            }
            arrayList = splits;
        }
        catch (Exception e) {
            try {
                logger.error("Failed to get InputSplits", (Throwable)e);
                throw new DrillRuntimeException("Failed to get InputSplits", (Throwable)e);
            }
            catch (Throwable throwable) {
                logger.debug("Took {} \u00b5s to get InputSplits from {}.{}", new Object[]{timeGetSplits.elapsed(TimeUnit.NANOSECONDS) / 1000L, hiveReadEntry.getTable().getDbName(), hiveReadEntry.getTable().getTableName()});
                throw throwable;
            }
        }
        logger.debug("Took {} \u00b5s to get InputSplits from {}.{}", new Object[]{timeGetSplits.elapsed(TimeUnit.NANOSECONDS) / 1000L, hiveReadEntry.getTable().getDbName(), hiveReadEntry.getTable().getTableName()});
        return arrayList;
    }

    protected List<String> getInputDirectories(HiveReadEntry hiveReadEntry) {
        if (this.isPartitionedTable) {
            ArrayList inputs = Lists.newArrayList();
            for (Partition p : hiveReadEntry.getPartitions()) {
                inputs.add(p.getSd().getLocation());
            }
            return inputs;
        }
        return Collections.singletonList(hiveReadEntry.getTable().getSd().getLocation());
    }

    private HiveStats getStatsFromProps(Properties properties) {
        long numRows = -1L;
        long sizeInBytes = -1L;
        try {
            String sizeInBytesProp;
            String numRowsProp = properties.getProperty("numRows");
            if (numRowsProp != null) {
                numRows = Long.valueOf(numRowsProp);
            }
            if ((sizeInBytesProp = properties.getProperty("totalSize")) != null) {
                sizeInBytes = Long.valueOf(numRowsProp);
            }
        }
        catch (NumberFormatException e) {
            logger.error("Failed to parse Hive stats in metastore.", (Throwable)e);
        }
        return new HiveStats(numRows, sizeInBytes);
    }

    private HiveStats getStatsEstimateFromInputSplits(List<InputSplitWrapper> inputSplits) throws IOException {
        long data = 0L;
        for (InputSplitWrapper split : inputSplits) {
            data += split.getSplit().getLength();
        }
        return new HiveStats(data / 1024L, data);
    }

    private List<InputSplitWrapper> splitInputWithUGI(final Properties properties, final StorageDescriptor sd, final Partition partition) throws Exception {
        this.watch.start();
        try {
            List list = (List)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<InputSplitWrapper>>(){

                @Override
                public List<InputSplitWrapper> run() throws Exception {
                    ArrayList splits = Lists.newArrayList();
                    JobConf job = new JobConf((Configuration)HiveMetadataProvider.this.hiveConf);
                    HiveUtilities.addConfToJob(job, properties);
                    job.setInputFormat(HiveUtilities.getInputFormatClass(job, sd, HiveMetadataProvider.this.hiveReadEntry.getTable()));
                    Path path = new Path(sd.getLocation());
                    FileSystem fs = path.getFileSystem((Configuration)job);
                    if (fs.exists(path)) {
                        FileInputFormat.addInputPath((JobConf)job, (Path)path);
                        InputFormat format = job.getInputFormat();
                        for (InputSplit split : format.getSplits(job, 1)) {
                            splits.add(new InputSplitWrapper(split, partition));
                        }
                    }
                    return splits;
                }
            });
            return list;
        }
        catch (IOException | InterruptedException e) {
            String errMsg = String.format("Failed to create input splits: %s", e.getMessage());
            logger.error(errMsg, (Throwable)e);
            throw new DrillRuntimeException(errMsg, (Throwable)e);
        }
        finally {
            logger.trace("Took {} \u00b5s to get splits from {}", (Object)(this.watch.elapsed(TimeUnit.NANOSECONDS) / 1000L), (Object)sd.getLocation());
            this.watch.stop();
        }
    }

    public static class HiveStats {
        private long numRows;
        private long sizeInBytes;

        public HiveStats(long numRows, long sizeInBytes) {
            this.numRows = numRows;
            this.sizeInBytes = sizeInBytes;
        }

        public long getNumRows() {
            return this.numRows;
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public boolean valid() {
            return this.numRows > 0L && this.sizeInBytes > 0L;
        }

        public void add(HiveStats s) {
            this.numRows += s.numRows;
            this.sizeInBytes += s.sizeInBytes;
        }

        public String toString() {
            return "numRows: " + this.numRows + ", sizeInBytes: " + this.sizeInBytes;
        }
    }

    public static class InputSplitWrapper {
        private InputSplit split;
        private Partition partition;

        public InputSplitWrapper(InputSplit split, Partition partition) {
            this.split = split;
            this.partition = partition;
        }

        public InputSplit getSplit() {
            return this.split;
        }

        public Partition getPartition() {
            return this.partition;
        }
    }
}

