/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import java.sql.Date;
import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class DrillDateDateObjectInspector {

    public static class Optional
    extends AbstractDrillPrimitiveObjectInspector
    implements DateObjectInspector {
        public Optional() {
            super(TypeInfoFactory.dateTypeInfo);
        }

        public Date getPrimitiveJavaObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableDateHolder h = (NullableDateHolder)o;
            return new Date(h.value);
        }

        public DateWritable getPrimitiveWritableObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableDateHolder h = (NullableDateHolder)o;
            return new DateWritable(new Date(h.value));
        }
    }

    public static class Required
    extends AbstractDrillPrimitiveObjectInspector
    implements DateObjectInspector {
        public Required() {
            super(TypeInfoFactory.dateTypeInfo);
        }

        public Date getPrimitiveJavaObject(Object o) {
            DateHolder h = (DateHolder)o;
            return new Date(h.value);
        }

        public DateWritable getPrimitiveWritableObject(Object o) {
            DateHolder h = (DateHolder)o;
            return new DateWritable(new Date(h.value));
        }
    }
}

