/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;

public class DrillBitBooleanObjectInspector {

    public static class Optional
    extends AbstractDrillPrimitiveObjectInspector
    implements BooleanObjectInspector {
        public Optional() {
            super(TypeInfoFactory.booleanTypeInfo);
        }

        public boolean get(Object o) {
            return ((NullableBitHolder)o).value != 0;
        }

        public BooleanWritable getPrimitiveWritableObject(Object o) {
            if (o == null) {
                return null;
            }
            return new BooleanWritable(((NullableBitHolder)o).value != 0);
        }

        public Boolean getPrimitiveJavaObject(Object o) {
            if (o == null) {
                return null;
            }
            return new Boolean(((NullableBitHolder)o).value != 0);
        }
    }

    public static class Required
    extends AbstractDrillPrimitiveObjectInspector
    implements BooleanObjectInspector {
        public Required() {
            super(TypeInfoFactory.booleanTypeInfo);
        }

        public boolean get(Object o) {
            return ((BitHolder)o).value != 0;
        }

        public BooleanWritable getPrimitiveWritableObject(Object o) {
            return new BooleanWritable(((BitHolder)o).value != 0);
        }

        public Boolean getPrimitiveJavaObject(Object o) {
            return new Boolean(((BitHolder)o).value != 0);
        }
    }
}

