/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;

abstract class MergeThread<T, K, V>
extends Thread {
    private static final Log LOG = LogFactory.getLog(MergeThread.class);
    private AtomicInteger numPending = new AtomicInteger(0);
    private LinkedList<List<T>> pendingToBeMerged = new LinkedList();
    protected final MergeManager<K, V> manager;
    private final ExceptionReporter reporter;
    private boolean closed = false;
    private final int mergeFactor;

    public MergeThread(MergeManager<K, V> manager, int mergeFactor, ExceptionReporter reporter) {
        this.manager = manager;
        this.mergeFactor = mergeFactor;
        this.reporter = reporter;
    }

    public synchronized void close() throws InterruptedException {
        this.closed = true;
        this.waitForMerge();
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMerge(Set<T> inputs) {
        if (!this.closed) {
            this.numPending.incrementAndGet();
            ArrayList<T> toMergeInputs = new ArrayList<T>();
            Iterator<T> iter = inputs.iterator();
            for (int ctr = 0; iter.hasNext() && ctr < this.mergeFactor; ++ctr) {
                toMergeInputs.add(iter.next());
                iter.remove();
            }
            LOG.info((Object)(this.getName() + ": Starting merge with " + toMergeInputs.size() + " segments, while ignoring " + inputs.size() + " segments"));
            LinkedList<List<T>> linkedList = this.pendingToBeMerged;
            synchronized (linkedList) {
                this.pendingToBeMerged.addLast(toMergeInputs);
                this.pendingToBeMerged.notifyAll();
            }
        }
    }

    public synchronized void waitForMerge() throws InterruptedException {
        while (this.numPending.get() > 0) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            List<T> inputs = null;
            try {
                LinkedList<List<T>> linkedList = this.pendingToBeMerged;
                synchronized (linkedList) {
                    while (this.pendingToBeMerged.size() <= 0) {
                        this.pendingToBeMerged.wait();
                    }
                    inputs = this.pendingToBeMerged.removeFirst();
                }
                this.merge(inputs);
                continue;
            }
            catch (InterruptedException ie) {
                this.numPending.set(0);
                return;
            }
            catch (Throwable t) {
                this.numPending.set(0);
                this.reporter.reportException(t);
                return;
            }
            finally {
                MergeThread mergeThread = this;
                synchronized (mergeThread) {
                    this.numPending.decrementAndGet();
                    this.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    public abstract void merge(List<T> var1) throws IOException;
}

