/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.NumberUtils;

public class VertexDescription {
    private double[] m_defaultPointAttributes;
    private int[] m_pointAttributeOffsets;
    int m_attributeCount;
    int m_total_component_count;
    int[] m_semantics;
    int[] m_semanticsToIndexMap;
    int m_hash;
    static double[] _defaultValues = new double[]{0.0, 0.0, NumberUtils.NaN(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    static int[] _interpolation = new int[]{1, 1, 1, 0, 2, 1, 1, 1, 0};
    static int[] _persistence = new int[]{1, 1, 1, 2, 0, 0, 0, 0, 2};
    static int[] _persistencesize = new int[]{4, 8, 4, 8, 1, 2};
    static int[] _components = new int[]{2, 1, 1, 1, 3, 1, 2, 3, 2};

    VertexDescription() {
        this.m_attributeCount = 0;
        this.m_total_component_count = 0;
    }

    VertexDescription(int hashValue, VertexDescription other) {
        int i;
        this.m_attributeCount = other.m_attributeCount;
        this.m_total_component_count = other.m_total_component_count;
        this.m_semantics = (int[])other.m_semantics.clone();
        this.m_semanticsToIndexMap = (int[])other.m_semanticsToIndexMap.clone();
        this.m_hash = other.m_hash;
        this.m_pointAttributeOffsets = new int[this.getAttributeCount()];
        int offset = 0;
        for (i = 0; i < this.getAttributeCount(); ++i) {
            this.m_pointAttributeOffsets[i] = offset;
            offset += VertexDescription.getComponentCount(this.m_semantics[i]);
        }
        this.m_total_component_count = offset;
        this.m_defaultPointAttributes = new double[offset];
        for (i = 0; i < this.getAttributeCount(); ++i) {
            int components = VertexDescription.getComponentCount(this.getSemantics(i));
            double dv = VertexDescription.getDefaultValue(this.getSemantics(i));
            for (int icomp = 0; icomp < components; ++icomp) {
                this.m_defaultPointAttributes[this.m_pointAttributeOffsets[i] + icomp] = dv;
            }
        }
    }

    public final int getAttributeCount() {
        return this.m_attributeCount;
    }

    public final int getSemantics(int attributeIndex) {
        if (attributeIndex < 0 || attributeIndex > this.m_attributeCount) {
            throw new IllegalArgumentException();
        }
        return this.m_semantics[attributeIndex];
    }

    public final int getAttributeIndex(int semantics) {
        return this.m_semanticsToIndexMap[semantics];
    }

    static int getInterpolation(int semantics) {
        return _interpolation[semantics];
    }

    static int getPersistence(int semantics) {
        return _persistence[semantics];
    }

    static int getPersistenceSize(int persistence) {
        return _persistencesize[persistence];
    }

    static int getPersistenceSizeSemantics(int semantics) {
        return VertexDescription.getPersistenceSize(VertexDescription.getPersistence(semantics)) * VertexDescription.getComponentCount(semantics);
    }

    public static int getComponentCount(int semantics) {
        return _components[semantics];
    }

    static boolean isIntegerPersistence(int persistence) {
        return persistence < 2;
    }

    static boolean isIntegerSemantics(int semantics) {
        return VertexDescription.isIntegerPersistence(VertexDescription.getPersistence(semantics));
    }

    public boolean hasAttribute(int semantics) {
        return this.m_semanticsToIndexMap[semantics] >= 0;
    }

    public boolean hasZ() {
        return this.hasAttribute(1);
    }

    public boolean hasM() {
        return this.hasAttribute(2);
    }

    public boolean hasID() {
        return this.hasAttribute(3);
    }

    public static double getDefaultValue(int semantics) {
        return _defaultValues[semantics];
    }

    int getPointAttributeOffset_(int attribute_index) {
        return this.m_pointAttributeOffsets[attribute_index];
    }

    public int getTotalComponentCount() {
        return this.m_total_component_count;
    }

    public static boolean isDefaultValue(int semantics, double v) {
        return NumberUtils.doubleToInt64Bits(_defaultValues[semantics]) == NumberUtils.doubleToInt64Bits(v);
    }

    static int getPersistenceFromInt(int size) {
        if (size == 4) {
            return 2;
        }
        if (size == 8) {
            return 3;
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object _other) {
        return this == _other;
    }

    int calculateHashImpl() {
        int v = NumberUtils.hash(this.m_semantics[0]);
        for (int i = 1; i < this.m_attributeCount; ++i) {
            v = NumberUtils.hash(v, this.m_semantics[i]);
        }
        return v;
    }

    double[] _getDefaultPointAttributes() {
        return this.m_defaultPointAttributes;
    }

    double _getDefaultPointAttributeValue(int attributeIndex, int ordinate) {
        return this.m_defaultPointAttributes[this._getPointAttributeOffset(attributeIndex) + ordinate];
    }

    int _getPointAttributeOffset(int attributeIndex) {
        return this.m_pointAttributeOffsets[attributeIndex];
    }

    int _getPointAttributeOffsetFromSemantics(int semantics) {
        return this.m_pointAttributeOffsets[this.getAttributeIndex(semantics)];
    }

    int _getTotalComponents() {
        return this.m_defaultPointAttributes.length;
    }

    public int hashCode() {
        return this.m_hash;
    }

    int _getSemanticsImpl(int attributeIndex) {
        return this.m_semantics[attributeIndex];
    }

    public static interface Semantics {
        public static final int POSITION = 0;
        public static final int Z = 1;
        public static final int M = 2;
        public static final int ID = 3;
        public static final int NORMAL = 4;
        public static final int TEXTURE1D = 5;
        public static final int TEXTURE2D = 6;
        public static final int TEXTURE3D = 7;
        public static final int ID2 = 8;
        public static final int MAXSEMANTICS = 10;
    }

    static interface Persistence {
        public static final int enumFloat = 0;
        public static final int enumDouble = 1;
        public static final int enumInt32 = 2;
        public static final int enumInt64 = 3;
        public static final int enumInt8 = 4;
        public static final int enumInt16 = 5;
    }

    static interface Interpolation {
        public static final int NONE = 0;
        public static final int LINEAR = 1;
        public static final int ANGULAR = 2;
    }
}

