/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.protobuf.Internal;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.rpc.BasicClient;
import org.apache.drill.exec.rpc.ConnectionThrottle;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.RpcConfig;
import org.apache.drill.exec.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicClientWithConnection<T extends Internal.EnumLite, HANDSHAKE_SEND extends MessageLite, HANDSHAKE_RESPONSE extends MessageLite>
extends BasicClient<T, ServerConnection, HANDSHAKE_SEND, HANDSHAKE_RESPONSE> {
    static final Logger logger = LoggerFactory.getLogger(BasicClientWithConnection.class);
    private BufferAllocator alloc;
    private final String connectionName;

    public BasicClientWithConnection(RpcConfig rpcMapping, BufferAllocator alloc, EventLoopGroup eventLoopGroup, T handshakeType, Class<HANDSHAKE_RESPONSE> responseClass, Parser<HANDSHAKE_RESPONSE> handshakeParser, String connectionName) {
        super(rpcMapping, alloc.getAsByteBufAllocator(), eventLoopGroup, handshakeType, responseClass, handshakeParser);
        this.alloc = alloc;
        this.connectionName = connectionName;
    }

    @Override
    protected Response handle(ServerConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        return this.handleReponse(connection, rpcType, pBody, dBody);
    }

    protected abstract Response handleReponse(ConnectionThrottle var1, int var2, ByteBuf var3, ByteBuf var4) throws RpcException;

    @Override
    public ServerConnection initRemoteConnection(SocketChannel channel) {
        super.initRemoteConnection(channel);
        return new ServerConnection(this.connectionName, channel, this.alloc);
    }

    public static class ServerConnection
    extends RemoteConnection {
        private final BufferAllocator alloc;

        public ServerConnection(String name, SocketChannel channel, BufferAllocator alloc) {
            super(channel, name);
            this.alloc = alloc;
        }

        @Override
        public BufferAllocator getAllocator() {
            return this.alloc;
        }
    }
}

