/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ojai.DocumentReader;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.EncodingException;
import org.ojai.exceptions.TypeException;

@API.Public
public class MapEncoder {
    public static Map<String, Object> encode(DocumentReader reader) throws EncodingException, TypeException {
        try {
            DocumentReader.EventType event = reader.next();
            if (event != DocumentReader.EventType.START_MAP) {
                throw new EncodingException("Expected " + (Object)((Object)DocumentReader.EventType.START_MAP) + ", received " + (Object)((Object)event));
            }
            return MapEncoder.encodeMap(reader);
        }
        catch (DecodingException de) {
            throw new EncodingException(de);
        }
    }

    private static Map<String, Object> encodeMap(DocumentReader dr) throws EncodingException, TypeException {
        try {
            LinkedHashMap<String, Object> docMap = new LinkedHashMap<String, Object>();
            DocumentReader.EventType event = null;
            block8: while (true) {
                if ((event = dr.next()) == null) {
                    throw new EncodingException("EOR: malformed document.");
                }
                switch (event) {
                    case START_MAP: {
                        docMap.put(dr.getFieldName(), MapEncoder.encodeMap(dr));
                        continue block8;
                    }
                    case END_MAP: {
                        return docMap;
                    }
                    case START_ARRAY: {
                        docMap.put(dr.getFieldName(), MapEncoder.encodeArray(dr));
                        continue block8;
                    }
                    case END_ARRAY: {
                        throw new EncodingException("END_ARRAY was not expected in encodeMap()");
                    }
                }
                docMap.put(dr.getFieldName(), MapEncoder.encodeValue(dr, event));
            }
        }
        catch (DecodingException de) {
            throw new EncodingException(de);
        }
    }

    private static List<Object> encodeArray(DocumentReader dr) throws EncodingException, TypeException {
        ArrayList<Object> objList = new ArrayList<Object>();
        DocumentReader.EventType event = null;
        try {
            event = dr.next();
        }
        catch (DecodingException de) {
            throw new EncodingException(de);
        }
        do {
            if (event == null) {
                throw new EncodingException("Malformed document");
            }
            switch (event) {
                case END_MAP: 
                case END_ARRAY: {
                    throw new EncodingException("Unexpected event: " + (Object)((Object)event));
                }
                case START_MAP: {
                    objList.add(dr.getArrayIndex(), MapEncoder.encodeMap(dr));
                    break;
                }
                case START_ARRAY: {
                    objList.add(dr.getArrayIndex(), MapEncoder.encodeArray(dr));
                    break;
                }
                default: {
                    objList.add(dr.getArrayIndex(), MapEncoder.encodeValue(dr, event));
                }
            }
            try {
                event = dr.next();
            }
            catch (DecodingException de) {
                throw new EncodingException(de);
            }
        } while (event != DocumentReader.EventType.END_ARRAY);
        return objList;
    }

    private static Object encodeValue(DocumentReader dr, DocumentReader.EventType event) throws EncodingException, TypeException {
        switch (event) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return dr.getBoolean();
            }
            case STRING: {
                return dr.getString();
            }
            case BYTE: {
                return dr.getByte();
            }
            case SHORT: {
                return dr.getShort();
            }
            case INT: {
                return dr.getInt();
            }
            case LONG: {
                return dr.getLong();
            }
            case FLOAT: {
                return Float.valueOf(dr.getFloat());
            }
            case DOUBLE: {
                return dr.getDouble();
            }
            case DECIMAL: {
                return dr.getDecimal();
            }
            case DATE: {
                return dr.getDate();
            }
            case TIME: {
                return dr.getTime();
            }
            case TIMESTAMP: {
                return dr.getTimestamp();
            }
            case INTERVAL: {
                return dr.getInterval();
            }
            case BINARY: {
                return dr.getBinary().duplicate();
            }
        }
        throw new EncodingException("Unexpected event: " + (Object)((Object)event));
    }
}

