/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.store;

import java.math.BigDecimal;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;
import org.ojai.store.exceptions.MultiOpException;
import org.ojai.store.exceptions.StoreException;

public interface DocumentStore
extends AutoCloseable {
    public boolean isReadOnly();

    public void flush() throws StoreException;

    public DocumentStream find() throws StoreException;

    public DocumentStream find(String ... var1) throws StoreException;

    public DocumentStream find(FieldPath ... var1) throws StoreException;

    public DocumentStream find(QueryCondition var1) throws StoreException;

    public DocumentStream find(QueryCondition var1, String ... var2) throws StoreException;

    public DocumentStream find(QueryCondition var1, FieldPath ... var2) throws StoreException;

    public void insertOrReplace(Document var1) throws StoreException;

    public void insertOrReplace(Value var1, Document var2) throws StoreException;

    public void insertOrReplace(Document var1, FieldPath var2) throws StoreException;

    public void insertOrReplace(Document var1, String var2) throws StoreException;

    public void insertOrReplace(DocumentStream var1) throws MultiOpException;

    public void insertOrReplace(DocumentStream var1, FieldPath var2) throws MultiOpException;

    public void insertOrReplace(DocumentStream var1, String var2) throws MultiOpException;

    public void update(Value var1, DocumentMutation var2) throws StoreException;

    public void delete(Value var1) throws StoreException;

    public void delete(Document var1) throws StoreException;

    public void delete(Document var1, FieldPath var2) throws StoreException;

    public void delete(Document var1, String var2) throws StoreException;

    public void delete(DocumentStream var1) throws MultiOpException;

    public void delete(DocumentStream var1, FieldPath var2) throws MultiOpException;

    public void delete(DocumentStream var1, String var2) throws MultiOpException;

    public void insert(Value var1, Document var2) throws StoreException;

    public void insert(Document var1) throws StoreException;

    public void insert(Document var1, FieldPath var2) throws StoreException;

    public void insert(Document var1, String var2) throws StoreException;

    public void insert(DocumentStream var1) throws MultiOpException;

    public void insert(DocumentStream var1, FieldPath var2) throws MultiOpException;

    public void insert(DocumentStream var1, String var2) throws MultiOpException;

    public void replace(Value var1, Document var2) throws StoreException;

    public void replace(Document var1) throws StoreException;

    public void replace(Document var1, FieldPath var2) throws StoreException;

    public void replace(Document var1, String var2) throws StoreException;

    public void replace(DocumentStream var1) throws MultiOpException;

    public void replace(DocumentStream var1, FieldPath var2) throws MultiOpException;

    public void replace(DocumentStream var1, String var2) throws MultiOpException;

    public void increment(Value var1, String var2, byte var3) throws StoreException;

    public void increment(Value var1, String var2, short var3) throws StoreException;

    public void increment(Value var1, String var2, int var3) throws StoreException;

    public void increment(Value var1, String var2, long var3) throws StoreException;

    public void increment(Value var1, String var2, float var3) throws StoreException;

    public void increment(Value var1, String var2, double var3) throws StoreException;

    public void increment(Value var1, String var2, BigDecimal var3) throws StoreException;

    public boolean checkAndMutate(Value var1, QueryCondition var2, DocumentMutation var3) throws StoreException;

    public boolean checkAndDelete(Value var1, QueryCondition var2) throws StoreException;

    public boolean checkAndReplace(Value var1, QueryCondition var2, Document var3) throws StoreException;

    @Override
    public void close() throws StoreException;
}

