/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.TypeException;
import org.ojai.json.impl.JsonDocument;
import org.ojai.json.impl.JsonList;
import org.ojai.json.impl.JsonValue;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@API.Internal
public class JsonValueBuilder {
    public static JsonValue initFromNull() {
        return JsonValue.NULLKEYVALUE;
    }

    public static JsonValue initFrom(boolean value) {
        JsonValue v = new JsonValue(Value.Type.BOOLEAN);
        v.setPrimValue(value ? 1L : 0L);
        return v;
    }

    public static JsonValue initFrom(String value) {
        JsonValue v = new JsonValue(Value.Type.STRING);
        v.setObjValue(value);
        return v;
    }

    public static JsonValue initFrom(byte value) {
        JsonValue v = new JsonValue(Value.Type.BYTE);
        v.setPrimValue(value);
        return v;
    }

    public static JsonValue initFrom(short value) {
        JsonValue v = new JsonValue(Value.Type.SHORT);
        v.setPrimValue(value);
        return v;
    }

    public static JsonValue initFrom(int value) {
        JsonValue v = new JsonValue(Value.Type.INT);
        v.setPrimValue(value);
        return v;
    }

    public static JsonValue initFrom(long value) {
        JsonValue v = new JsonValue(Value.Type.LONG);
        v.setPrimValue(value);
        return v;
    }

    public static JsonValue initFrom(float value) {
        JsonValue v = new JsonValue(Value.Type.FLOAT);
        v.setPrimValue(Float.floatToIntBits(value));
        return v;
    }

    public static JsonValue initFrom(double value) {
        JsonValue v = new JsonValue(Value.Type.DOUBLE);
        v.setPrimValue(Double.doubleToLongBits(value));
        return v;
    }

    public static JsonValue initFrom(OTime value) {
        JsonValue v = new JsonValue(Value.Type.TIME);
        v.setPrimValue(value.toTimeInMillis());
        return v;
    }

    public static JsonValue initFrom(ODate value) {
        JsonValue v = new JsonValue(Value.Type.DATE);
        v.setPrimValue(value.toDaysSinceEpoch());
        return v;
    }

    public static JsonValue initFrom(BigDecimal value) {
        JsonValue v = new JsonValue(Value.Type.DECIMAL);
        v.setObjValue(value);
        return v;
    }

    public static JsonValue initFrom(OTimestamp value) {
        JsonValue v = new JsonValue(Value.Type.TIMESTAMP);
        v.setPrimValue(value.getMillis());
        return v;
    }

    public static JsonValue initFrom(OInterval value) {
        JsonValue v = new JsonValue(Value.Type.INTERVAL);
        v.setPrimValue(value.getTimeInMillis());
        return v;
    }

    public static JsonValue initFrom(ByteBuffer value) {
        JsonValue v = new JsonValue(Value.Type.BINARY);
        v.setObjValue(value);
        return v;
    }

    public static <T> JsonValue initFrom(List<T> list) {
        if (list instanceof JsonList) {
            return (JsonValue)((Object)list);
        }
        JsonList l = new JsonList();
        for (T o : list) {
            l.addToList(JsonValueBuilder.initFromObject(o));
        }
        return l;
    }

    public static <T> JsonValue initFrom(Map<String, T> map) {
        if (map instanceof JsonDocument) {
            return ((JsonDocument)map).shallowCopy();
        }
        JsonDocument rec = new JsonDocument();
        for (String k : map.keySet()) {
            rec.set(k, (Value)JsonValueBuilder.initFromObject(map.get(k)));
        }
        return rec;
    }

    public static JsonValue initFrom(Document value) {
        if (value instanceof JsonDocument) {
            return ((JsonDocument)value).shallowCopy();
        }
        JsonDocument r = new JsonDocument();
        for (Map.Entry e : value) {
            r.set((String)e.getKey(), (Value)JsonValueBuilder.initFromObject(e.getValue()));
        }
        return r;
    }

    public static JsonValue initFrom(Value value) {
        if (value instanceof JsonValue) {
            return ((JsonValue)value).shallowCopy();
        }
        return JsonValueBuilder.initFromObject(value.getObject());
    }

    public static JsonValue initFromObject(Object value) {
        if (value instanceof JsonValue) {
            return (JsonValue)value;
        }
        if (value == null) {
            return JsonValue.NULLKEYVALUE;
        }
        if (value instanceof Byte) {
            return JsonValueBuilder.initFrom((Byte)value);
        }
        if (value instanceof Boolean) {
            return JsonValueBuilder.initFrom((Boolean)value);
        }
        if (value instanceof String) {
            return JsonValueBuilder.initFrom((String)value);
        }
        if (value instanceof Short) {
            return JsonValueBuilder.initFrom((Short)value);
        }
        if (value instanceof Integer) {
            return JsonValueBuilder.initFrom((Integer)value);
        }
        if (value instanceof Long) {
            return JsonValueBuilder.initFrom((Long)value);
        }
        if (value instanceof Float) {
            return JsonValueBuilder.initFrom(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return JsonValueBuilder.initFrom((Double)value);
        }
        if (value instanceof OTime) {
            return JsonValueBuilder.initFrom((OTime)value);
        }
        if (value instanceof ODate) {
            return JsonValueBuilder.initFrom((ODate)value);
        }
        if (value instanceof OTimestamp) {
            return JsonValueBuilder.initFrom((OTimestamp)value);
        }
        if (value instanceof BigDecimal) {
            return JsonValueBuilder.initFrom((BigDecimal)value);
        }
        if (value instanceof ByteBuffer) {
            return JsonValueBuilder.initFrom((ByteBuffer)value);
        }
        if (value instanceof OInterval) {
            return JsonValueBuilder.initFrom((OInterval)value);
        }
        if (value instanceof Document) {
            return JsonValueBuilder.initFrom((Document)value);
        }
        if (value instanceof Map) {
            return JsonValueBuilder.initFrom((Map)value);
        }
        if (value instanceof List) {
            return JsonValueBuilder.initFrom((List)value);
        }
        if (value instanceof Value) {
            return JsonValueBuilder.initFrom((Value)value);
        }
        if (value.getClass().isArray()) {
            return JsonValueBuilder.initFromArray(value);
        }
        throw new TypeException("Unsupported object type for value " + value);
    }

    public static JsonValue initFromArray(Object value) {
        Class<?> c = value.getClass().getComponentType();
        if (c.isPrimitive()) {
            if (c == Byte.TYPE) {
                byte[] v = (byte[])value;
                return JsonValueBuilder.initFromArray(v);
            }
            if (c == Short.TYPE) {
                short[] v = (short[])value;
                return JsonValueBuilder.initFromArray(v);
            }
            if (c == Integer.TYPE) {
                int[] v = (int[])value;
                return JsonValueBuilder.initFromArray(v);
            }
            if (c == Long.TYPE) {
                long[] v = (long[])value;
                return JsonValueBuilder.initFromArray(v);
            }
            if (c == Float.TYPE) {
                float[] v = (float[])value;
                return JsonValueBuilder.initFromArray(v);
            }
            if (c == Double.TYPE) {
                double[] v = (double[])value;
                return JsonValueBuilder.initFromArray(v);
            }
            if (c == Boolean.TYPE) {
                boolean[] v = (boolean[])value;
                return JsonValueBuilder.initFromArray(v);
            }
            if (c == Character.TYPE) {
                char[] v = (char[])value;
                return JsonValueBuilder.initFromArray(v);
            }
        } else {
            return JsonValueBuilder.initFromArray((Object[])value);
        }
        return null;
    }

    private static JsonValue initFromArray(byte[] values) {
        JsonList list = new JsonList();
        for (int i = 0; i < values.length; ++i) {
            list.addToList(JsonValueBuilder.initFrom(values[i]));
        }
        return list;
    }

    private static JsonValue initFromArray(short[] values) {
        JsonList list = new JsonList();
        for (int i = 0; i < values.length; ++i) {
            list.addToList(JsonValueBuilder.initFrom(values[i]));
        }
        return list;
    }

    private static JsonValue initFromArray(int[] values) {
        JsonList list = new JsonList();
        for (int i = 0; i < values.length; ++i) {
            list.addToList(JsonValueBuilder.initFrom(values[i]));
        }
        return list;
    }

    private static JsonValue initFromArray(long[] values) {
        JsonList list = new JsonList();
        for (int i = 0; i < values.length; ++i) {
            list.addToList(JsonValueBuilder.initFrom(values[i]));
        }
        return list;
    }

    private static JsonValue initFromArray(float[] values) {
        JsonList list = new JsonList();
        for (int i = 0; i < values.length; ++i) {
            list.addToList(JsonValueBuilder.initFrom(values[i]));
        }
        return list;
    }

    private static JsonValue initFromArray(double[] values) {
        JsonList list = new JsonList();
        for (int i = 0; i < values.length; ++i) {
            list.addToList(JsonValueBuilder.initFrom(values[i]));
        }
        return list;
    }

    private static JsonValue initFromArray(boolean[] values) {
        JsonList list = new JsonList();
        for (int i = 0; i < values.length; ++i) {
            list.addToList(JsonValueBuilder.initFrom(values[i]));
        }
        return list;
    }

    private static JsonValue initFromArray(char[] values) {
        JsonList list = new JsonList();
        for (int i = 0; i < values.length; ++i) {
            list.addToList(JsonValueBuilder.initFrom((short)values[i]));
        }
        return list;
    }

    private static JsonValue initFromArray(Object[] values) {
        JsonList list = new JsonList();
        for (int i = 0; i < values.length; ++i) {
            list.addToList(JsonValueBuilder.initFromObject(values[i]));
        }
        return list;
    }
}

