/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import java.util.LinkedList;
import java.util.Queue;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.json.Events;
import org.ojai.json.impl.JsonDocumentStream;
import org.ojai.json.impl.JsonStreamDocumentReader;

@API.Internal
public class DelegatingJsonDocumentReader
extends JsonStreamDocumentReader {
    private final Queue<Events.EventDescriptor> eventQueue = new LinkedList<Events.EventDescriptor>();
    private final Events.Delegate eventDelegate;
    private int depth = 0;

    DelegatingJsonDocumentReader(JsonDocumentStream stream, Events.Delegate eventDelegate) {
        super(stream);
        if (eventDelegate == null) {
            throw new NullPointerException("Event delegate must be provided.");
        }
        this.eventDelegate = eventDelegate;
    }

    @Override
    public DocumentReader.EventType next() {
        DocumentReader.EventType et = null;
        et = !this.eventQueue.isEmpty() ? this.updateCurrentValue(this.eventQueue.remove()) : super.next();
        if (et != null) {
            if (et == DocumentReader.EventType.START_MAP && this.depth++ == 0) {
                if (this.eventDelegate.bor(this, this.eventQueue)) {
                    et = this.next();
                }
            } else if (et == DocumentReader.EventType.END_MAP && --this.depth == 0) {
                if (this.eventDelegate.eor(this, this.eventQueue)) {
                    et = this.next();
                }
            } else if (this.eventDelegate.process(this, et, this.eventQueue)) {
                et = this.next();
            }
        }
        return et;
    }

    private DocumentReader.EventType updateCurrentValue(Events.EventDescriptor eventDesc) {
        this.setCurrentEventType(eventDesc.getEventType());
        Value value = eventDesc.getValue();
        if (eventDesc.getFieldName() != null) {
            this.setFieldName(eventDesc.getFieldName());
        }
        if (eventDesc.getIndex() != -1) {
            this.setArrayIndex(eventDesc.getIndex());
        }
        switch (this.getCurrentEventType()) {
            case BOOLEAN: {
                this.setCurrentObj(value.getBoolean());
                break;
            }
            case STRING: {
                this.setCurrentObj(value.getString());
                break;
            }
            case BYTE: {
                this.setCurrentLongValue(value.getByte());
                break;
            }
            case SHORT: {
                this.setCurrentLongValue(value.getShort());
                break;
            }
            case INT: {
                this.setCurrentLongValue(value.getInt());
                break;
            }
            case LONG: {
                this.setCurrentLongValue(value.getLong());
                break;
            }
            case FLOAT: {
                this.setCurrentDoubleValue(value.getFloat());
                break;
            }
            case DOUBLE: {
                this.setCurrentDoubleValue(value.getDouble());
                break;
            }
            case DECIMAL: {
                this.setCurrentObj(value.getDecimal());
                break;
            }
            case DATE: {
                this.setCurrentObj(value.getDate());
                break;
            }
            case TIME: {
                this.setCurrentObj(value.getTime());
                break;
            }
            case TIMESTAMP: {
                this.setCurrentObj(value.getTimestamp());
                break;
            }
            case INTERVAL: {
                this.setCurrentLongValue(value.getIntervalAsLong());
                break;
            }
            case BINARY: {
                this.setCurrentObj(value.getBinary());
                break;
            }
        }
        return this.getCurrentEventType();
    }
}

