/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json;

public class JsonOptions {
    public static final JsonOptions DEFAULT = new JsonOptions();
    public static final JsonOptions WITH_TAGS = new JsonOptions().withTags();
    private boolean pretty = false;
    private boolean withTags = false;

    public boolean isPretty() {
        return this.pretty;
    }

    public JsonOptions setPretty(boolean pretty) {
        this.checkMutationOfConstants();
        this.pretty = pretty;
        return this;
    }

    public JsonOptions pretty() {
        this.checkMutationOfConstants();
        this.pretty = true;
        return this;
    }

    public JsonOptions compact() {
        this.checkMutationOfConstants();
        this.pretty = false;
        return this;
    }

    public boolean isWithTags() {
        return this.withTags;
    }

    public JsonOptions setWithTags(boolean withTags) {
        this.checkMutationOfConstants();
        this.withTags = withTags;
        return this;
    }

    public JsonOptions withTags() {
        this.checkMutationOfConstants();
        this.withTags = true;
        return this;
    }

    public JsonOptions withoutTags() {
        this.checkMutationOfConstants();
        this.withTags = false;
        return this;
    }

    private void checkMutationOfConstants() {
        if (this == DEFAULT || this == WITH_TAGS) {
            throw new UnsupportedOperationException("Can not modify constants options.");
        }
    }

    public String toString() {
        return "{\"pretty\":" + this.pretty + ", \"withTags\":" + this.withTags + "}";
    }
}

