/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.util;

import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import org.apache.drill.common.util.RepeatTestRule;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class TestTools {
    static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    static final String WORKING_PATH = Paths.get("", new String[0]).toAbsolutePath().toString();
    private static final String PATH_SEPARATOR = System.getProperty("file.separator");
    private static final String[] STRUCTURE = new String[]{"drill", "exec", "java-exec", "src", "test", "resources"};

    public static TestRule getTimeoutRule() {
        return TestTools.getTimeoutRule(10000);
    }

    public static TestRule getTimeoutRule(int timeout) {
        return IS_DEBUG ? new TestName() : new Timeout(timeout);
    }

    public static TestRule getRepeatRule(boolean enforce) {
        return enforce || !IS_DEBUG ? new RepeatTestRule() : new TestName();
    }

    public static String getWorkingPath() {
        return WORKING_PATH;
    }

    public static String getTestResourcesPath() {
        StringBuilder builder = new StringBuilder(WORKING_PATH);
        for (int i = 0; i < STRUCTURE.length; ++i) {
            if (!WORKING_PATH.endsWith(STRUCTURE[i])) continue;
            for (int j = i + 1; j < STRUCTURE.length; ++j) {
                builder.append(PATH_SEPARATOR).append(STRUCTURE[j]);
            }
            return builder.toString();
        }
        String msg = String.format("Unable to recognize working directory[%s]. The workspace must be root or exec module.", WORKING_PATH);
        throw new IllegalStateException(msg);
    }
}

