/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.util;

import org.apache.drill.common.util.DrillBaseComputeScalePrecision;

public class DecimalScalePrecisionAddFunction
extends DrillBaseComputeScalePrecision {
    public DecimalScalePrecisionAddFunction(int leftPrecision, int leftScale, int rightPrecision, int rightScale) {
        super(leftPrecision, leftScale, rightPrecision, rightScale);
    }

    @Override
    public void computeScalePrecision(int leftPrecision, int leftScale, int rightPrecision, int rightScale) {
        this.outputScale = Math.max(leftScale, rightScale);
        int maxResultIntegerDigits = Math.max(leftPrecision - leftScale, rightPrecision - rightScale) + 1;
        this.outputPrecision = this.outputScale + maxResultIntegerDigits;
        if (this.outputPrecision > 38) {
            this.outputPrecision = 38;
            this.outputScale = this.outputPrecision - maxResultIntegerDigits >= 0 ? this.outputPrecision - maxResultIntegerDigits : 0;
        }
    }
}

