/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedLatch
extends CountDownLatch {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedLatch.class);

    public ExtendedLatch() {
        super(1);
    }

    public ExtendedLatch(int count) {
        super(count);
    }

    public boolean awaitUninterruptibly(long waitMillis) {
        long targetMillis = System.currentTimeMillis() + waitMillis;
        while (System.currentTimeMillis() < targetMillis) {
            long wait = targetMillis - System.currentTimeMillis();
            if (wait < 1L) {
                return false;
            }
            try {
                return this.await(wait, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
            }
        }
        return false;
    }

    public void awaitUninterruptibly() {
        while (true) {
            try {
                this.await();
                return;
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while waiting for event latch.", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

