/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import com.typesafe.config.Config;
import org.apache.drill.yarn.client.ClientCommand;
import org.apache.drill.yarn.client.ClientException;
import org.apache.drill.yarn.client.SimpleRestClient;
import org.apache.drill.yarn.client.StatusCommand;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.drill.yarn.core.YarnClientException;
import org.apache.drill.yarn.core.YarnRMClient;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;

public class StopCommand
extends ClientCommand {
    private Config config;
    private YarnRMClient client;

    @Override
    public void run() throws ClientException {
        this.config = DrillOnYarnConfig.config();
        this.client = this.getClient();
        System.out.println("Stopping Application ID: " + this.client.getAppId().toString());
        StatusCommand.Reporter reporter = new StatusCommand.Reporter(this.client);
        try {
            reporter.getReport();
        }
        catch (ClientException e) {
            reporter = null;
        }
        boolean stopped = true;
        if (reporter == null || reporter.isStopped()) {
            System.out.println("Application is not running.");
        } else {
            if (this.opts.force) {
                System.out.println("Forcing shutdown");
            } else {
                stopped = this.gracefulStop(reporter.getAmUrl());
            }
            if (this.opts.force || !stopped) {
                this.forcefulStop();
            }
            stopped = new StopMonitor(this.config, reporter).run(this.opts.verbose);
        }
        if (stopped) {
            this.removeAppIdFile();
        }
    }

    private boolean gracefulStop(String baseUrl) {
        try {
            String result;
            if (DoYUtil.isBlank(baseUrl)) {
                return false;
            }
            SimpleRestClient restClient = new SimpleRestClient();
            String tail = "rest/stop";
            String masterKey = this.config.getString(DrillOnYarnConfig.HTTP_REST_KEY);
            if (!DoYUtil.isBlank(masterKey)) {
                tail = tail + "?key=" + masterKey;
            }
            if (this.opts.verbose) {
                System.out.println("Stopping with POST " + baseUrl + "/" + tail);
            }
            if ((result = restClient.send(baseUrl, tail, true)).contains("\"ok\"")) {
                return true;
            }
            System.err.println("Failed to stop the application master. Response = " + result);
            return false;
        }
        catch (ClientException e) {
            System.err.println(e.getMessage());
            System.out.println("Resorting to forced kill");
            return false;
        }
    }

    private void forcefulStop() throws ClientException {
        try {
            this.client.killApplication();
        }
        catch (YarnClientException e) {
            throw new ClientException("Failed to stop application master", e);
        }
    }

    private static class StopMonitor {
        StatusCommand.Reporter reporter;
        private YarnApplicationState state;
        private int pollWaitSec;
        private int shutdownWaitSec;

        StopMonitor(Config config, StatusCommand.Reporter reporter) {
            this.reporter = reporter;
            this.pollWaitSec = config.getInt(DrillOnYarnConfig.CLIENT_POLL_SEC);
            if (this.pollWaitSec < 1) {
                this.pollWaitSec = 1;
            }
            this.shutdownWaitSec = config.getInt(DrillOnYarnConfig.CLIENT_STOP_WAIT_SEC);
        }

        boolean run(boolean verbose) throws ClientException {
            System.out.print("Stopping...");
            try {
                int attemptCount = this.shutdownWaitSec / this.pollWaitSec;
                for (int attempt = 0; attempt < attemptCount && this.poll(); ++attempt) {
                }
            }
            catch (ClientException e) {
                System.out.println();
                throw e;
            }
            if (this.reporter.isStopped()) {
                System.out.println(" Stopped.");
                this.reporter.showFinalStatus();
                return true;
            }
            System.out.println();
            System.out.println("Application Master is slow to stop, use YARN to check status.");
            return false;
        }

        private boolean poll() throws ClientException {
            try {
                Thread.sleep(this.pollWaitSec * 1000);
            }
            catch (InterruptedException e) {
                return false;
            }
            this.reporter.getReport();
            if (this.reporter.isStopped()) {
                return false;
            }
            YarnApplicationState newState = this.reporter.getState();
            if (newState == this.state) {
                System.out.print(".");
                return true;
            }
            this.updateState(newState);
            return true;
        }

        private void updateState(YarnApplicationState newState) {
            YarnApplicationState oldState = this.state;
            this.state = newState;
            if (oldState == null) {
                return;
            }
            System.out.println();
            System.out.print("Application State: ");
            System.out.println(this.state.toString());
            System.out.print("Stopping...");
        }
    }
}

