/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.ClusterConf;
import com.mapr.fs.hbase.HTableDescriptorProxy;
import com.mapr.fs.hbase.MapRDBConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class HTableProperties
implements MapRDBConstants {
    public static final String DISABLED = "DISABLED";
    private static final Map<ImmutableBytesWritable, ImmutableBytesWritable> DEFAULT_TABLE_PROPERTIES = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
    private static Map<String, Map<ImmutableBytesWritable, ImmutableBytesWritable>> tableProperties = new HashMap<String, Map<ImmutableBytesWritable, ImmutableBytesWritable>>();
    private static Object tbl_prop_lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertiesToTableDescriptor(Path table, HTableDescriptor desc) {
        Object object = tbl_prop_lock;
        synchronized (object) {
            Map<ImmutableBytesWritable, ImmutableBytesWritable> props = HTableProperties.getProps(table);
            if (props != null) {
                for (ImmutableBytesWritable key : props.keySet()) {
                    HTableDescriptorProxy.setValue(desc, key.get(), props.get(key).get());
                }
            }
        }
    }

    public static void removeProperties(Path table) {
        String path = HTableProperties.convertPath(table.toUri().getPath());
        tableProperties.remove(path);
    }

    public static String getTableProperty(Path table, String key) {
        return HTableProperties.getTableProperty(table, new ImmutableBytesWritable(Bytes.toBytes((String)key)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTableProperty(Path table, ImmutableBytesWritable key) {
        Object object = tbl_prop_lock;
        synchronized (object) {
            Map<ImmutableBytesWritable, ImmutableBytesWritable> props = HTableProperties.getProps(table);
            ImmutableBytesWritable value = null;
            if (props == null || (value = props.get(key)) == null) {
                value = DEFAULT_TABLE_PROPERTIES.get(key);
                String string = value != null ? Bytes.toString((byte[])value.get()) : null;
                return string;
            }
            return Bytes.toString((byte[])value.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTableProperty(Path table, String key, String value) {
        Object object = tbl_prop_lock;
        synchronized (object) {
            Map<ImmutableBytesWritable, ImmutableBytesWritable> props = HTableProperties.getProps(table);
            if (props == null) {
                props = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
                HTableProperties.setProps(table, props);
            }
            HTableProperties.putVal(props, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTableProperties(Path table, Map<ImmutableBytesWritable, ImmutableBytesWritable> map) {
        Object object = tbl_prop_lock;
        synchronized (object) {
            Map<ImmutableBytesWritable, ImmutableBytesWritable> props = HTableProperties.getProps(table);
            if (props == null) {
                props = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
                HTableProperties.setProps(table, props);
            }
            for (ImmutableBytesWritable key : map.keySet()) {
                props.put(key, map.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getColumnProperty(Path table, String cf, String key) {
        Object object = tbl_prop_lock;
        synchronized (object) {
        }
        return cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setColumnProperty(Path table, String cf, String key, String value) {
        Object object = tbl_prop_lock;
        synchronized (object) {
        }
    }

    protected static Map<ImmutableBytesWritable, ImmutableBytesWritable> getProps(Path table) {
        String path = HTableProperties.convertPath(table.toUri().getPath());
        return tableProperties.get(path);
    }

    protected static void setProps(Path table, Map<ImmutableBytesWritable, ImmutableBytesWritable> props) {
        String path = HTableProperties.convertPath(table.toUri().getPath());
        tableProperties.put(path, props);
    }

    protected static String convertPath(String path) {
        List list;
        String newPath = path;
        if (!newPath.matches("^/mapr/.+") && (list = new ClusterConf().getClusterList()) != null && list.size() > 0) {
            newPath = "/mapr/" + ((ClusterConf.ClusterEntry)list.get(0)).getClusterName() + path;
        }
        return newPath;
    }

    protected static void putVal(Map<ImmutableBytesWritable, ImmutableBytesWritable> map, String key, String value) {
        HTableProperties.putVal(map, new ImmutableBytesWritable(Bytes.toBytes((String)key)), value);
    }

    protected static void putVal(Map<ImmutableBytesWritable, ImmutableBytesWritable> map, ImmutableBytesWritable key, String value) {
        map.put(key, new ImmutableBytesWritable(Bytes.toBytes((String)value)));
    }

    static {
        HTableProperties.putVal(DEFAULT_TABLE_PROPERTIES, DISABLED, FALSE);
        HTableProperties.putVal(DEFAULT_TABLE_PROPERTIES, "DEFERRED_LOG_FLUSH", FALSE);
        HTableProperties.putVal(DEFAULT_TABLE_PROPERTIES, "MAX_FILESIZE", String.valueOf(0x280000000L));
        HTableProperties.putVal(DEFAULT_TABLE_PROPERTIES, "MEMSTORE_FLUSHSIZE", String.valueOf(0x8000000L));
        HTableProperties.putVal(DEFAULT_TABLE_PROPERTIES, "READONLY", FALSE);
        HTableProperties.putVal(DEFAULT_TABLE_PROPERTIES, "SPLIT_POLICY", "");
    }
}

