/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Util;

public class UnionMergeRule
extends RelOptRule {
    public static final UnionMergeRule INSTANCE = new UnionMergeRule(LogicalUnion.class, RelFactories.DEFAULT_SET_OP_FACTORY);
    private final RelFactories.SetOpFactory setOpFactory;

    public UnionMergeRule(Class<? extends Union> clazz, RelFactories.SetOpFactory setOpFactory) {
        super(UnionMergeRule.operand(clazz, UnionMergeRule.operand(RelNode.class, UnionMergeRule.any()), UnionMergeRule.operand(RelNode.class, UnionMergeRule.any())));
        this.setOpFactory = setOpFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Union bottomUnion;
        Union topUnion = (Union)call.rel(0);
        if (call.rel(2) instanceof Union) {
            bottomUnion = (Union)call.rel(2);
        } else if (call.rel(1) instanceof Union) {
            bottomUnion = (Union)call.rel(1);
        } else {
            return;
        }
        if (!topUnion.all || !bottomUnion.all) {
            return;
        }
        ArrayList<RelNode> unionInputs = new ArrayList<RelNode>();
        if (call.rel(2) instanceof Union) {
            assert (topUnion.getInputs().size() == 2);
            unionInputs.add(topUnion.getInput(0));
            unionInputs.addAll(bottomUnion.getInputs());
        } else {
            unionInputs.addAll(bottomUnion.getInputs());
            unionInputs.addAll(Util.skip(topUnion.getInputs()));
        }
        assert (unionInputs.size() == bottomUnion.getInputs().size() + topUnion.getInputs().size() - 1);
        RelNode newUnion = this.setOpFactory.createSetOp(SqlKind.UNION, unionInputs, true);
        call.transformTo(newUnion);
    }
}

