/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.calcite.util.Pair;

class CachingLatticeStatisticProvider
implements LatticeStatisticProvider {
    private final LoadingCache<Pair<Lattice, Lattice.Column>, Integer> cache;

    public CachingLatticeStatisticProvider(final LatticeStatisticProvider provider) {
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Pair<Lattice, Lattice.Column>, Integer>(){

            public Integer load(Pair<Lattice, Lattice.Column> key) throws Exception {
                return provider.cardinality((Lattice)key.left, (Lattice.Column)key.right);
            }
        });
    }

    @Override
    public int cardinality(Lattice lattice, Lattice.Column column) {
        try {
            return (Integer)this.cache.get(Pair.of(lattice, column));
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

