/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.TypedValue;

public interface Service {
    public ResultSetResponse apply(CatalogsRequest var1);

    public ResultSetResponse apply(SchemasRequest var1);

    public ResultSetResponse apply(TablesRequest var1);

    public ResultSetResponse apply(TableTypesRequest var1);

    public ResultSetResponse apply(TypeInfoRequest var1);

    public ResultSetResponse apply(ColumnsRequest var1);

    public PrepareResponse apply(PrepareRequest var1);

    public ExecuteResponse apply(PrepareAndExecuteRequest var1);

    public FetchResponse apply(FetchRequest var1);

    public CreateStatementResponse apply(CreateStatementRequest var1);

    public CloseStatementResponse apply(CloseStatementRequest var1);

    public CloseConnectionResponse apply(CloseConnectionRequest var1);

    public ConnectionSyncResponse apply(ConnectionSyncRequest var1);

    public DatabasePropertyResponse apply(DatabasePropertyRequest var1);

    public static class DatabasePropertyResponse
    extends Response {
        public final Map<Meta.DatabaseProperty, Object> map;

        @JsonCreator
        public DatabasePropertyResponse(@JsonProperty(value="map") Map<Meta.DatabaseProperty, Object> map) {
            this.map = map;
        }
    }

    public static class ConnectionSyncResponse
    extends Response {
        public final Meta.ConnectionProperties connProps;

        @JsonCreator
        public ConnectionSyncResponse(@JsonProperty(value="connProps") Meta.ConnectionProperties connProps) {
            this.connProps = connProps;
        }
    }

    public static class ConnectionSyncRequest
    extends Request {
        public final String connectionId;
        public final Meta.ConnectionProperties connProps;

        @JsonCreator
        public ConnectionSyncRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="connProps") Meta.ConnectionProperties connProps) {
            this.connectionId = connectionId;
            this.connProps = connProps;
        }

        @Override
        ConnectionSyncResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class CloseConnectionResponse
    extends Response {
        @JsonCreator
        public CloseConnectionResponse() {
        }
    }

    public static class CloseConnectionRequest
    extends Request {
        public final String connectionId;

        @JsonCreator
        public CloseConnectionRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        CloseConnectionResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class CloseStatementResponse
    extends Response {
        @JsonCreator
        public CloseStatementResponse() {
        }
    }

    public static class CloseStatementRequest
    extends Request {
        public final String connectionId;
        public final int statementId;

        @JsonCreator
        public CloseStatementRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId) {
            this.connectionId = connectionId;
            this.statementId = statementId;
        }

        @Override
        CloseStatementResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class CreateStatementResponse
    extends Response {
        public final String connectionId;
        public final int statementId;

        @JsonCreator
        public CreateStatementResponse(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId) {
            this.connectionId = connectionId;
            this.statementId = statementId;
        }
    }

    public static class CreateStatementRequest
    extends Request {
        public final String connectionId;

        @JsonCreator
        public CreateStatementRequest(@JsonProperty(value="signature") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        CreateStatementResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class FetchResponse
    extends Response {
        public final Meta.Frame frame;

        @JsonCreator
        public FetchResponse(@JsonProperty(value="frame") Meta.Frame frame) {
            this.frame = frame;
        }
    }

    public static class FetchRequest
    extends Request {
        public final String connectionId;
        public final int statementId;
        public final long offset;
        public final int fetchMaxRowCount;
        public final List<TypedValue> parameterValues;

        @JsonCreator
        public FetchRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="parameterValues") List<TypedValue> parameterValues, @JsonProperty(value="offset") long offset, @JsonProperty(value="fetchMaxRowCount") int fetchMaxRowCount) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.parameterValues = parameterValues;
            this.offset = offset;
            this.fetchMaxRowCount = fetchMaxRowCount;
        }

        @Override
        FetchResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class PrepareResponse
    extends Response {
        public final Meta.StatementHandle statement;

        @JsonCreator
        public PrepareResponse(@JsonProperty(value="statement") Meta.StatementHandle statement) {
            this.statement = statement;
        }
    }

    public static class PrepareRequest
    extends Request {
        public final String connectionId;
        public final String sql;
        public final long maxRowCount;

        @JsonCreator
        public PrepareRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="sql") String sql, @JsonProperty(value="maxRowCount") long maxRowCount) {
            this.connectionId = connectionId;
            this.sql = sql;
            this.maxRowCount = maxRowCount;
        }

        @Override
        PrepareResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class ExecuteResponse
    extends Response {
        public final List<ResultSetResponse> results;

        @JsonCreator
        public ExecuteResponse(@JsonProperty(value="resultSets") List<ResultSetResponse> results) {
            this.results = results;
        }
    }

    public static class PrepareAndExecuteRequest
    extends Request {
        public final String connectionId;
        public final String sql;
        public final long maxRowCount;
        public final int statementId;

        @JsonCreator
        public PrepareAndExecuteRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="sql") String sql, @JsonProperty(value="maxRowCount") long maxRowCount) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.sql = sql;
            this.maxRowCount = maxRowCount;
        }

        @Override
        ExecuteResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class ResultSetResponse
    extends Response {
        public final String connectionId;
        public final int statementId;
        public final boolean ownStatement;
        public final Meta.Signature signature;
        public final Meta.Frame firstFrame;
        public final long updateCount;

        @JsonCreator
        public ResultSetResponse(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="ownStatement") boolean ownStatement, @JsonProperty(value="signature") Meta.Signature signature, @JsonProperty(value="firstFrame") Meta.Frame firstFrame, @JsonProperty(value="updateCount") long updateCount) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.ownStatement = ownStatement;
            this.signature = signature;
            this.firstFrame = firstFrame;
            this.updateCount = updateCount;
        }
    }

    public static class TypeInfoRequest
    extends Request {
        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class ColumnsRequest
    extends Request {
        public final String catalog;
        public final String schemaPattern;
        public final String tableNamePattern;
        public final String columnNamePattern;

        @JsonCreator
        public ColumnsRequest(@JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern, @JsonProperty(value="tableNamePattern") String tableNamePattern, @JsonProperty(value="columnNamePattern") String columnNamePattern) {
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
            this.tableNamePattern = tableNamePattern;
            this.columnNamePattern = columnNamePattern;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class TableTypesRequest
    extends Request {
        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class TablesRequest
    extends Request {
        public final String catalog;
        public final String schemaPattern;
        public final String tableNamePattern;
        public final List<String> typeList;

        @JsonCreator
        public TablesRequest(@JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern, @JsonProperty(value="tableNamePattern") String tableNamePattern, @JsonProperty(value="typeList") List<String> typeList) {
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
            this.tableNamePattern = tableNamePattern;
            this.typeList = typeList;
        }

        @Override
        Response accept(Service service) {
            return service.apply(this);
        }
    }

    public static class SchemasRequest
    extends Request {
        public final String catalog;
        public final String schemaPattern;

        @JsonCreator
        public SchemasRequest(@JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern) {
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class DatabasePropertyRequest
    extends Request {
        @JsonCreator
        public DatabasePropertyRequest() {
        }

        @Override
        DatabasePropertyResponse accept(Service service) {
            return service.apply(this);
        }
    }

    public static class CatalogsRequest
    extends Request {
        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="response", defaultImpl=ResultSetResponse.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ResultSetResponse.class, name="resultSet"), @JsonSubTypes.Type(value=PrepareResponse.class, name="prepare"), @JsonSubTypes.Type(value=FetchResponse.class, name="fetch"), @JsonSubTypes.Type(value=CreateStatementResponse.class, name="createStatement"), @JsonSubTypes.Type(value=CloseStatementResponse.class, name="closeStatement"), @JsonSubTypes.Type(value=CloseConnectionResponse.class, name="closeConnection"), @JsonSubTypes.Type(value=ConnectionSyncResponse.class, name="connectionSync"), @JsonSubTypes.Type(value=DatabasePropertyResponse.class, name="databaseProperties")})
    public static abstract class Response {
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="request", defaultImpl=SchemasRequest.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CatalogsRequest.class, name="getCatalogs"), @JsonSubTypes.Type(value=SchemasRequest.class, name="getSchemas"), @JsonSubTypes.Type(value=TablesRequest.class, name="getTables"), @JsonSubTypes.Type(value=TableTypesRequest.class, name="getTableTypes"), @JsonSubTypes.Type(value=TypeInfoRequest.class, name="getTypeInfo"), @JsonSubTypes.Type(value=ColumnsRequest.class, name="getColumns"), @JsonSubTypes.Type(value=PrepareRequest.class, name="prepare"), @JsonSubTypes.Type(value=PrepareAndExecuteRequest.class, name="prepareAndExecute"), @JsonSubTypes.Type(value=FetchRequest.class, name="fetch"), @JsonSubTypes.Type(value=CreateStatementRequest.class, name="createStatement"), @JsonSubTypes.Type(value=CloseStatementRequest.class, name="closeStatement"), @JsonSubTypes.Type(value=CloseConnectionRequest.class, name="closeConnection"), @JsonSubTypes.Type(value=ConnectionSyncRequest.class, name="connectionSync"), @JsonSubTypes.Type(value=DatabasePropertyRequest.class, name="databaseProperties")})
    public static abstract class Request {
        abstract Response accept(Service var1);
    }

    public static interface Factory {
        public Service create(AvaticaConnection var1);
    }
}

