/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.drill.common.logical.AbstractSecuredStoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.store.security.CredentialProviderUtils;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;

@JsonTypeName(value="elastic")
public class ElasticsearchStorageConfig
extends AbstractSecuredStoragePluginConfig {
    public static final String NAME = "elastic";
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writerFor(List.class);
    private static final String HOSTS = "hosts";
    private static final String PATH_PREFIX = "pathPrefix";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    public static final String CREDENTIALS_PROVIDER = "credentialsProvider";
    private static final String EMPTY_STRING = "";
    private final List<String> hosts;
    private final String pathPrefix;

    @JsonCreator
    public ElasticsearchStorageConfig(@JsonProperty(value="hosts") List<String> hosts, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="pathPrefix") String pathPrefix, @JsonProperty(value="credentialsProvider") CredentialsProvider credentialsProvider) {
        super(CredentialProviderUtils.getCredentialsProvider((String)username, (String)password, (CredentialsProvider)credentialsProvider), credentialsProvider == null);
        this.hosts = hosts;
        this.pathPrefix = pathPrefix;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public String getUsername() {
        if (this.directCredentials) {
            return this.getUsernamePasswordCredentials().getUsername();
        }
        return null;
    }

    public String getPassword() {
        if (this.directCredentials) {
            return this.getUsernamePasswordCredentials().getPassword();
        }
        return null;
    }

    @JsonIgnore
    public UsernamePasswordCredentials getUsernamePasswordCredentials() {
        return new UsernamePasswordCredentials(this.credentialsProvider);
    }

    @JsonIgnore
    public Map<String, Object> toConfigMap() throws JsonProcessingException {
        HashMap credentials = new HashMap(this.credentialsProvider.getCredentials());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)HOSTS, (Object)OBJECT_WRITER.writeValueAsString(this.hosts));
        builder.put((Object)PATH_PREFIX, (Object)(this.pathPrefix != null ? this.pathPrefix : EMPTY_STRING));
        builder.put((Object)USERNAME, (Object)credentials.getOrDefault(USERNAME, EMPTY_STRING));
        builder.put((Object)PASSWORD, (Object)credentials.getOrDefault(PASSWORD, EMPTY_STRING));
        credentials.remove(USERNAME);
        credentials.remove(PASSWORD);
        builder.putAll(credentials);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchStorageConfig that = (ElasticsearchStorageConfig)((Object)o);
        return Objects.equals(this.hosts, that.hosts) && Objects.equals(this.credentialsProvider, that.credentialsProvider);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.credentialsProvider);
    }
}

