/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.druid.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractSchemaFactory;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.druid.DruidScanSpec;
import org.apache.drill.exec.store.druid.DruidStoragePlugin;
import org.apache.drill.exec.store.druid.druid.SimpleDatasourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidSchemaFactory
extends AbstractSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(DruidSchemaFactory.class);
    private final DruidStoragePlugin plugin;

    public DruidSchemaFactory(DruidStoragePlugin plugin, String schemaName) {
        super(schemaName);
        this.plugin = plugin;
    }

    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) {
        DruidDataSources schema = new DruidDataSources(this.getName());
        SchemaPlus hPlus = parent.add(this.getName(), (Schema)schema);
        schema.setHolder(hPlus);
    }

    public class DruidDataSources
    extends AbstractSchema {
        private final Set<String> tableNames;
        private final Map<String, DrillTable> drillTables;
        private Map<String, SimpleDatasourceInfo> druidDatasourceInfos;

        public DruidDataSources(String name) {
            super((List)ImmutableList.of(), name);
            this.drillTables = Maps.newHashMap();
            this.druidDatasourceInfos = Maps.newHashMap();
            this.tableNames = this.getTableNames();
        }

        public void setHolder(SchemaPlus plusOfThis) {
        }

        public AbstractSchema getSubSchema(String name) {
            return null;
        }

        public Set<String> getSubSchemaNames() {
            return Collections.emptySet();
        }

        public Table getTable(String tableName) {
            if (!this.tableNames.contains(tableName)) {
                return null;
            }
            try {
                if (!this.drillTables.containsKey(tableName)) {
                    SimpleDatasourceInfo simpleDatasourceInfo = this.druidDatasourceInfos.get(tableName);
                    DruidScanSpec scanSpec = new DruidScanSpec(tableName, simpleDatasourceInfo.getProperties().getSegments().getSize(), simpleDatasourceInfo.getProperties().getSegments().getMinTime(), simpleDatasourceInfo.getProperties().getSegments().getMaxTime());
                    DynamicDrillTable dynamicDrillTable = new DynamicDrillTable((StoragePlugin)DruidSchemaFactory.this.plugin, this.getName(), null, (DrillTableSelection)scanSpec);
                    this.drillTables.put(tableName, (DrillTable)dynamicDrillTable);
                }
                return (Table)this.drillTables.get(tableName);
            }
            catch (Exception e) {
                logger.warn("Failure while retrieving druid table {}", (Object)tableName, (Object)e);
                return null;
            }
        }

        public Set<String> getTableNames() {
            try {
                List<SimpleDatasourceInfo> dataSources = DruidSchemaFactory.this.plugin.getAdminClient().getDataSources();
                this.druidDatasourceInfos = dataSources.stream().collect(Collectors.toMap(SimpleDatasourceInfo::getName, x -> x));
                Set<String> dataSourceNames = this.druidDatasourceInfos.keySet();
                logger.debug("Found Druid DataSources - {}", (Object)StringUtils.join(dataSourceNames, (String)","));
                return dataSourceNames;
            }
            catch (Exception e) {
                throw UserException.dataReadError((Throwable)e).message("Failure while loading druid datasources for database '%s'.", new Object[]{this.getName()}).build(logger);
            }
        }

        public String getTypeName() {
            return "druid";
        }
    }
}

