/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;

public class ColumnListsCache {
    private final List<List<FieldSchema>> fields = new ArrayList<List<FieldSchema>>();
    private final Map<List<FieldSchema>, Integer> keys = new HashMap<List<FieldSchema>, Integer>();

    public ColumnListsCache(Table table) {
        this();
        this.addOrGet(table.getSd().getCols());
    }

    public ColumnListsCache() {
    }

    public int addOrGet(List<FieldSchema> columns) {
        if (columns == null) {
            return -1;
        }
        Integer index = this.keys.get(columns);
        if (index != null) {
            return index;
        }
        index = this.fields.size();
        ImmutableList immutableList = ImmutableList.copyOf(columns);
        this.fields.add((List<FieldSchema>)immutableList);
        this.keys.put((List<FieldSchema>)immutableList, index);
        return index;
    }

    public List<FieldSchema> getColumns(int index) {
        return index > -1 && index < this.fields.size() ? this.fields.get(index) : null;
    }

    public List<FieldSchema> getTableSchemaColumns() {
        List<FieldSchema> tableSchemaColumns = this.getColumns(0);
        Preconditions.checkNotNull(tableSchemaColumns, (Object)"Failed to get columns for Hive table from cache.");
        return tableSchemaColumns;
    }

    public List<List<FieldSchema>> getFields() {
        return new ArrayList<List<FieldSchema>>(this.fields);
    }
}

