/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;

public class DrillVarBinaryBinaryObjectInspector {

    public static class Optional
    extends AbstractDrillPrimitiveObjectInspector
    implements BinaryObjectInspector {
        public Optional() {
            super(TypeInfoFactory.binaryTypeInfo);
        }

        public BytesWritable getPrimitiveWritableObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableVarBinaryHolder h = (NullableVarBinaryHolder)o;
            byte[] buf = new byte[h.end - h.start];
            h.buffer.getBytes(h.start, buf, 0, h.end - h.start);
            return new BytesWritable(buf);
        }

        public byte[] getPrimitiveJavaObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableVarBinaryHolder h = (NullableVarBinaryHolder)o;
            byte[] buf = new byte[h.end - h.start];
            h.buffer.getBytes(h.start, buf, 0, h.end - h.start);
            return buf;
        }
    }

    public static class Required
    extends AbstractDrillPrimitiveObjectInspector
    implements BinaryObjectInspector {
        public Required() {
            super(TypeInfoFactory.binaryTypeInfo);
        }

        public BytesWritable getPrimitiveWritableObject(Object o) {
            VarBinaryHolder h = (VarBinaryHolder)o;
            byte[] buf = new byte[h.end - h.start];
            h.buffer.getBytes(h.start, buf, 0, h.end - h.start);
            return new BytesWritable(buf);
        }

        public byte[] getPrimitiveJavaObject(Object o) {
            VarBinaryHolder h = (VarBinaryHolder)o;
            byte[] buf = new byte[h.end - h.start];
            h.buffer.getBytes(h.start, buf, 0, h.end - h.start);
            return buf;
        }
    }
}

