/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.hdfs.BmcProperties;
import com.oracle.bmc.hdfs.store.BmcOutputStream;
import com.oracle.bmc.hdfs.store.BmcPropertyAccessor;
import com.oracle.bmc.hdfs.store.MultipartUploadRequest;
import com.oracle.bmc.hdfs.util.BlockingRejectionHandler;
import com.oracle.bmc.io.DuplicatableInputStream;
import com.oracle.bmc.objectstorage.model.CreateMultipartUploadDetails;
import com.oracle.bmc.objectstorage.model.StorageTier;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.responses.CommitMultipartUploadResponse;
import com.oracle.bmc.objectstorage.transfer.MultipartManifest;
import com.oracle.bmc.objectstorage.transfer.MultipartObjectAssembler;
import com.oracle.bmc.objectstorage.transfer.internal.StreamHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcMultipartOutputStream
extends BmcOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(BmcMultipartOutputStream.class);
    private final int bufferSizeInBytes;
    private final MultipartUploadRequest request;
    private ByteBufferOutputStream bbos;
    private MultipartObjectAssembler assembler;
    private volatile boolean closed = false;
    private MultipartManifest manifest;
    private ExecutorService executor;
    private boolean shutdownExecutor;
    private final BmcPropertyAccessor propertyAccessor;

    public BmcMultipartOutputStream(BmcPropertyAccessor propertyAccessor, MultipartUploadRequest request, int bufferSizeInBytes) {
        super(null, null);
        this.propertyAccessor = propertyAccessor;
        this.bufferSizeInBytes = bufferSizeInBytes;
        this.request = request;
        this.shutdownExecutor = false;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            LOG.debug("Output stream already closed");
            return;
        }
        if (this.manifest == null) {
            LOG.debug("Nothing written to stream, creating empty object");
            PutObjectRequest putEmptyFileRequest = PutObjectRequest.builder().putObjectBody((InputStream)new ByteArrayInputStream(new byte[0])).namespaceName(this.request.getMultipartUploadRequest().getNamespaceName()).bucketName(this.request.getMultipartUploadRequest().getBucketName()).objectName(this.request.getMultipartUploadRequest().getCreateMultipartUploadDetails().getObject()).buildWithoutInvocationCallback();
            this.request.getObjectStorage().putObject(putEmptyFileRequest);
            return;
        }
        this.closed = true;
        try {
            this.doUpload();
            LOG.info(String.format("Committing multipart upload id=%s, this awaits all transfers.", this.manifest.getUploadId()));
            CommitMultipartUploadResponse r = this.assembler.commit();
            LOG.info(String.format("Committed all parts for uploadId=%s, etag: %s", this.manifest.getUploadId(), r.getETag()));
        }
        catch (Exception e) {
            String errorMsg = String.format("Multipart upload id=%s has failed parts=%d, aborting...", this.manifest.getUploadId(), this.manifest.listFailedParts().size());
            LOG.warn(errorMsg);
            this.assembler.abort();
            throw new IOException("Unable to put object via multipart upload", e);
        }
        finally {
            this.bbos.close();
            this.bbos = null;
            if (!this.executor.isShutdown() && this.shutdownExecutor) {
                this.executor.shutdown();
            }
            this.executor = null;
        }
    }

    private String computeMd5(byte[] bytes, int length) {
        StreamHelper.NullOutputStream os = new StreamHelper.NullOutputStream();
        String md5Base64 = null;
        try (DigestOutputStream dos = new DigestOutputStream((OutputStream)os, MessageDigest.getInstance("MD5"));){
            dos.write(bytes, 0, length);
            md5Base64 = StreamHelper.base64Encode((MessageDigest)dos.getMessageDigest());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            LOG.warn("Failed to compute MD5", (Throwable)ex);
        }
        return md5Base64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doUpload() {
        if (this.bbos.isEmpty()) {
            return;
        }
        byte[] bytesToWrite = this.bbos.toByteArray();
        int writeLength = bytesToWrite.length;
        try (WrappedFixedLengthByteArrayInputStream is = new WrappedFixedLengthByteArrayInputStream(bytesToWrite, 0, writeLength);){
            this.assembler.addPart((InputStream)is, (long)writeLength, this.computeMd5(bytesToWrite, writeLength));
        }
        catch (IOException ioe) {
            LOG.error("Failed to create InputStream from byte array.");
        }
        finally {
            this.bbos.clear();
        }
    }

    private synchronized void initializeExecutorService() {
        if (this.executor == null) {
            int taskTimeout = this.propertyAccessor.asInteger().get(BmcProperties.MULTIPART_IN_MEMORY_WRITE_TASK_TIMEOUT_SECONDS);
            int numThreadsForParallelUpload = this.propertyAccessor.asInteger().get(BmcProperties.MULTIPART_NUM_UPLOAD_THREADS);
            BlockingRejectionHandler rejectedExecutionHandler = new BlockingRejectionHandler(taskTimeout);
            this.executor = new ThreadPoolExecutor(numThreadsForParallelUpload, numThreadsForParallelUpload, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(numThreadsForParallelUpload), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("bmcs-hdfs-multipart-upload-%d").build(), rejectedExecutionHandler);
            this.shutdownExecutor = true;
        }
    }

    @Override
    protected OutputStream createOutputBufferStream() {
        this.initializeExecutorService();
        CreateMultipartUploadDetails details = this.request.getMultipartUploadRequest().getCreateMultipartUploadDetails();
        this.assembler = MultipartObjectAssembler.builder().allowOverwrite(this.request.isAllowOverwrite()).bucketName(this.request.getMultipartUploadRequest().getBucketName()).namespaceName(this.request.getMultipartUploadRequest().getNamespaceName()).objectName(details.getObject()).cacheControl(details.getCacheControl()).storageTier(details.getStorageTier() == null ? StorageTier.Standard : details.getStorageTier()).contentDisposition(details.getContentDisposition()).executorService(this.executor).opcClientRequestId(this.request.getMultipartUploadRequest().getOpcClientRequestId()).retryConfiguration(this.request.getRetryConfiguration()).service(this.request.getObjectStorage()).build();
        this.bbos = new ByteBufferOutputStream(this.bufferSizeInBytes);
        this.manifest = this.assembler.newRequest(null, null, null, null);
        return this.bbos;
    }

    @Override
    protected long getInputStreamLengthInBytes() {
        return this.bbos.length();
    }

    @Override
    protected InputStream getInputStreamFromBufferedStream() {
        byte[] bytes = this.bbos.toByteArray();
        return new WrappedFixedLengthByteArrayInputStream(bytes, 0, bytes.length);
    }

    private class WrappedFixedLengthByteArrayInputStream
    extends ByteArrayInputStream
    implements DuplicatableInputStream {
        private final int length;
        private final int offset;

        private WrappedFixedLengthByteArrayInputStream(byte[] buf) {
            super(buf);
            this.length = buf.length;
            this.offset = 0;
        }

        private WrappedFixedLengthByteArrayInputStream(byte[] buf, int off, int length) {
            super(buf, off, length);
            this.length = length;
            this.offset = off;
        }

        public long length() {
            return this.length;
        }

        public InputStream duplicate() {
            return new WrappedFixedLengthByteArrayInputStream(this.buf, this.offset, this.length);
        }
    }

    private class ByteBufferOutputStream
    extends OutputStream {
        private final ByteBuffer buffer;
        private final int size;

        private ByteBufferOutputStream(int size) {
            this.size = size;
            this.buffer = ByteBuffer.allocate(this.size);
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.put((byte)b);
            if (!this.buffer.hasRemaining()) {
                BmcMultipartOutputStream.this.doUpload();
                this.buffer.clear();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException, NullPointerException, IndexOutOfBoundsException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (this.outOfRange(off, b.length) || len < 0 || this.outOfRange(off + len, b.length)) {
                throw new IndexOutOfBoundsException();
            }
            if (len > 0) {
                if (this.buffer.remaining() <= len) {
                    int first = this.buffer.remaining();
                    this.buffer.put(b, off, first);
                    BmcMultipartOutputStream.this.doUpload();
                    this.buffer.clear();
                    this.write(b, off + first, len - first);
                } else {
                    this.buffer.put(b, off, len);
                }
            }
        }

        private boolean outOfRange(int off, int len) {
            return off < 0 || off > len;
        }

        private void clear() {
            this.buffer.clear();
        }

        private int length() {
            return this.buffer.hasRemaining() ? this.size - this.buffer.remaining() : this.size;
        }

        private boolean isEmpty() {
            return this.buffer.remaining() == this.size;
        }

        private byte[] toByteArray() {
            return ArrayUtils.subarray((byte[])this.buffer.array(), (int)0, (int)this.length());
        }

        @Override
        public void close() throws IOException {
            BmcMultipartOutputStream.this.close();
        }
    }
}

