/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;

public class LaskowskiProjection
extends Projection {
    private static final double a10 = 0.975534;
    private static final double a12 = -0.119161;
    private static final double a32 = -0.0143059;
    private static final double a14 = -0.0547009;
    private static final double b01 = 1.00384;
    private static final double b21 = 0.0802894;
    private static final double b03 = 0.0998909;
    private static final double b41 = 1.99025E-4;
    private static final double b23 = -0.02855;
    private static final double b05 = -0.0491032;

    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double l2 = lplam * lplam;
        double p2 = lpphi * lpphi;
        out.x = lplam * (0.975534 + p2 * (-0.119161 + l2 * -0.0143059 + p2 * -0.0547009));
        out.y = lpphi * (1.00384 + l2 * (0.0802894 + p2 * -0.02855 + l2 * 1.99025E-4) + p2 * (0.0998909 + p2 * -0.0491032));
        return out;
    }

    public String toString() {
        return "Laskowski";
    }
}

