/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public enum SqlLibrary {
    STANDARD(""),
    SPATIAL("s"),
    MYSQL("m"),
    ORACLE("o"),
    POSTGRESQL("p");

    public final String abbrev;
    public final String fun;
    public static final Map<String, SqlLibrary> MAP;

    private SqlLibrary(String abbrev) {
        this.abbrev = Objects.requireNonNull(abbrev);
        this.fun = this.name().toLowerCase(Locale.ROOT);
    }

    public static SqlLibrary of(String name) {
        return MAP.get(name);
    }

    public static List<SqlLibrary> parse(String libraryNameList) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (String libraryName : libraryNameList.split(",")) {
            list.add((Object)SqlLibrary.of(libraryName));
        }
        return list.build();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SqlLibrary value : SqlLibrary.values()) {
            builder.put((Object)value.name(), (Object)value);
            builder.put((Object)value.fun, (Object)value);
        }
        MAP = builder.build();
    }
}

