/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import com.typesafe.config.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.drill.yarn.client.ClientException;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;

public class SimpleRestClient {
    /*
     * Enabled aggressive exception aggregation
     */
    public String send(String baseUrl, String resource, boolean isPost) throws ClientException {
        String url = baseUrl;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + resource;
        try {
            SSLContext sslContext = SSLContexts.createDefault();
            Config config = DrillOnYarnConfig.config();
            if (config.hasPath(DrillOnYarnConfig.DISABLE_CERT_VERIFICATION) && config.getBoolean(DrillOnYarnConfig.DISABLE_CERT_VERIFICATION)) {
                sslContext = SSLContexts.custom().loadTrustMaterial(null, (cert, authType) -> true).build();
            }
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            if (config.hasPath(DrillOnYarnConfig.DISABLE_HOST_VERIFICATION) && config.getBoolean(DrillOnYarnConfig.DISABLE_HOST_VERIFICATION) || config.hasPath(DrillOnYarnConfig.DISABLE_CERT_VERIFICATION) && config.getBoolean(DrillOnYarnConfig.DISABLE_CERT_VERIFICATION)) {
                sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
            BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)connectionManager).build();){
                String string;
                block19: {
                    Object request = isPost ? new HttpPost(url) : new HttpGet(url);
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                    try {
                        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                        StringBuilder buf = new StringBuilder();
                        String line = null;
                        while ((line = rd.readLine()) != null) {
                            buf.append(line);
                        }
                        string = buf.toString().trim();
                        if (response == null) break block19;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    response.close();
                }
                return string;
            }
        }
        catch (IllegalStateException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | ClientProtocolException e) {
            throw new ClientException("Internal REST error", (Exception)e);
        }
        catch (IOException e) {
            throw new ClientException("REST request failed: " + url, e);
        }
    }
}

