/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.yarn.client.ClientContext;

public class CommandLineOptions {
    Command command;
    public String appId;
    public boolean dryRun;
    public String resizePrefix;
    public int resizeValue;
    public boolean verbose = false;
    public boolean force = false;

    public boolean parse(String[] args) {
        block0: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-h") || arg.equals("-?")) {
                this.command = Command.HELP;
                break;
            }
            if (arg.equals("-v") || arg.equals("--verbose")) {
                this.verbose = true;
                continue;
            }
            if (arg.equals("-f") || arg.equals("--force")) {
                this.force = true;
                continue;
            }
            if (arg.equals("-d") || arg.equals("--dryrun")) {
                this.dryRun = true;
                continue;
            }
            if (arg.equals("-a") || arg.equals("--appid")) {
                if (i + 1 == args.length) {
                    return false;
                }
                this.appId = args[++i];
                continue;
            }
            if (this.command != null) {
                this.command = null;
                return false;
            }
            String cmdStr = arg;
            if (cmdStr.startsWith("--")) {
                cmdStr = arg.substring(2);
            } else if (cmdStr.startsWith("-")) {
                cmdStr = cmdStr.substring(1);
            }
            for (Command cmd : Command.values()) {
                if (!cmd.isMatch(cmdStr)) continue;
                this.command = cmd;
                if (this.command != Command.RESIZE) continue block0;
                if (i + 1 == args.length) {
                    this.command = null;
                    continue block0;
                }
                this.parseResizeOption(args[++i]);
                continue block0;
            }
        }
        return true;
    }

    private void parseResizeOption(String resize) {
        Pattern p = Pattern.compile("([+-]?)(\\d+)");
        Matcher m = p.matcher(resize);
        if (!m.matches()) {
            this.command = null;
            return;
        }
        this.resizePrefix = m.group(1);
        this.resizeValue = Integer.parseInt(m.group(2));
    }

    public Command getCommand() {
        return this.command;
    }

    public String getResizePrefix() {
        return this.resizePrefix;
    }

    public int getResizeValue() {
        return this.resizeValue;
    }

    public void usage() {
        ClientContext.out.println("Usage: drill-on-yarn.sh [--site site-dir] command [-v|--verbose][-a app-id]");
        ClientContext.out.println("Where command is one of:");
        for (Command cmd : Command.values()) {
            if (cmd.isHidden()) continue;
            ClientContext.out.println("  " + cmd.getCommand() + " - " + cmd.getDescription());
        }
    }

    public static enum Command {
        HELP("help", "Provide description of usage."),
        START("start", "Start the cluster."),
        STOP("stop", "Stop the cluster."),
        STATUS("status", "Provide the status of the cluster."),
        RESIZE("resize", "Resize the cluster +n: add nodes, -n: remove nodes, n resize to given size."),
        TEST(null, null),
        DESCRIBE("describe", "Display and validate configuration."),
        UPLOAD("upload", "Upload archives to validate DFS."),
        CLEAN("clean", "Remove archives stored in DFS.");

        private String cmd;
        private String descrip;

        private Command(String cmd, String descrip) {
            this.cmd = cmd;
            this.descrip = descrip;
        }

        public boolean isMatch(String arg) {
            String key = this.cmd == null ? this.toString() : this.cmd;
            return key.equalsIgnoreCase(arg);
        }

        public boolean isHidden() {
            return this.descrip == null;
        }

        public String getCommand() {
            return this.cmd;
        }

        public String getDescription() {
            return this.descrip;
        }
    }
}

