/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.MapRCommonSecurityUtil;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.YarnAppUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRTicketUploader {
    private static final Logger LOG = LoggerFactory.getLogger(MapRTicketUploader.class);

    public void uploadToken(ApplicationId appId, Configuration conf) {
        try {
            if (!UserGroupInformation.isSecurityEnabled() || UserGroupInformation.getCurrentUser().getRealUser() != null) {
                return;
            }
            this.upload(appId.toString(), conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(String appIdStr, Configuration conf) throws IOException {
        String ticketPath = MapRCommonSecurityUtil.getInstance().getUserTicketAndKeyFileLocation();
        if (ticketPath == null) {
            LOG.warn("Security is enabled, but userTicketFile is null. May cause failures later.");
            return;
        }
        File ticketFile = new File(ticketPath);
        if (!ticketFile.exists() || !ticketFile.isFile()) {
            LOG.warn("Security is enabled, but userTicketFile cannot be found. May cause failures later.");
            return;
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path appStagingDir = YarnAppUtil.getRMStagingDirForWrite(appIdStr, fs, conf);
        Path outTicketFilePath = YarnAppUtil.getMapRTicketPath(appStagingDir);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Uploading MapR ticket for app: " + appIdStr + " at " + outTicketFilePath + " . Source ticket: " + ticketPath);
        }
        FileSystem.mkdirs((FileSystem)fs, (Path)appStagingDir, (FsPermission)YarnAppUtil.APP_DIR_PERMISSION);
        FSDataOutputStream outTicket = FileSystem.create((FileSystem)fs, (Path)outTicketFilePath, (FsPermission)new FsPermission(YarnAppUtil.APP_FILE_PERMISSION));
        FileInputStream fis = new FileInputStream(ticketFile);
        byte[] inBytes = new byte[1024];
        try {
            int ticketLen;
            while ((ticketLen = fis.read(inBytes)) != -1) {
                outTicket.write(inBytes, 0, ticketLen);
            }
        }
        finally {
            fis.close();
            outTicket.close();
        }
    }
}

